/*
 * EnterpriseGroupManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.enterprise;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.enterprise.IEnterpriseGroupManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.EnterpriseGroupMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.EnterpriseGroup;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * 
 * 
 * @author Eraldo Neto - HMGL
 * 
 */
public class EnterpriseGroupManagerConsumerSoapImpl implements
        IEnterpriseGroupManagerConsumer {

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Logging ] */

    private static final Logger LOGGER = Logger
            .getLogger(EnterpriseGroupManagerConsumerSoapImpl.class);

    /* [ Logging ] */

    /* [ Operators ] */

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #find(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<EnterpriseGroup> find(MessageHeader messageHeader,
            String enterpriseGroupId) {

        LOGGER
                .info("Fazendo chamada para consulta de grupo corporativo a partir do ID usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findEnterpriseGroupById(smh, enterpriseGroupId);

        // Converte o retorno.
        ReturnMessage<EnterpriseGroup> rm = ReturnMessageMounter
                .mountLocalObjectWithEnterpriseGroupValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        LOGGER
                .info("Chamada para para consulta de grupo corporativo a partir do ID usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #find(br.com.petrobras.security.consume.MessageHeader, java.util.List)
     */
    public ReturnMessage<List<EnterpriseGroup>> find(
            MessageHeader messageHeader, List<String> enterpriseGroupIds) {

        LOGGER
                .info("Fazendo chamada para consulta de grupos corporativos a partir de IDs usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findEnterpriseGroupsById(smh,
                        enterpriseGroupIds);

        // Converte o retorno.
        ReturnMessage<List<EnterpriseGroup>> rm = ReturnMessageMounter
                .mountLocalObjectWithEnterpriseGroupListValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        LOGGER
                .info("Chamada para para consulta de grupos corporativos a partir de IDs usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<EnterpriseGroup>> findAll(
            MessageHeader messageHeader) {

        LOGGER
                .info("Fazendo chamada para consulta de todos os grupos corporativos usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllEnterpriseGroups(smh);

        // Converte o retorno.
        ReturnMessage<List<EnterpriseGroup>> rm = ReturnMessageMounter
                .mountLocalObjectWithEnterpriseGroupListValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        LOGGER
                .info("Chamada para consulta de todos os grupos corporativos usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #remove(br.com.petrobras.security.consume.MessageHeader,
     * java.lang.String)
     */
    public ReturnMessage<Boolean> remove(MessageHeader messageHeader,
            String enterpriseGroupId) {

        LOGGER
                .info("Fazendo chamada para remoo de grupo corporativo usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .removeEnterpriseGroup(smh, enterpriseGroupId);

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER
                .info("Chamada para remoo de grupo corporativo usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #save(br.com.petrobras.security.consume.MessageHeader,
     * br.com.petrobras.security.model.EnterpriseGroup)
     */
    public ReturnMessage<Boolean> save(MessageHeader messageHeader,
            EnterpriseGroup enterpriseGroup) {

        LOGGER
                .info("Fazendo chamada para incluso de grupo corporativo usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .saveEnterpriseGroup(
                        smh,
                        EnterpriseGroupMounter
                                .mountTransferObject(enterpriseGroup));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER
                .info("Chamada para incluso de grupo corporativo usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #update(br.com.petrobras.security.consume.MessageHeader,
     * br.com.petrobras.security.model.EnterpriseGroup)
     */
    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            EnterpriseGroup enterpriseGroup) {

        LOGGER
                .info("Fazendo chamada para atualizao de grupo corporativo usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .updateEnterpriseGroupWithUidLoaded(
                        smh,
                        EnterpriseGroupMounter
                                .mountTransferObject(enterpriseGroup));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER
                .info("Chamada para atualizao de grupo corporativo usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #update(br.com.petrobras.security.consume.MessageHeader,
     * java.lang.String, br.com.petrobras.security.model.EnterpriseGroup)
     */
    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            String oldId, EnterpriseGroup enterpriseGroup) {

        LOGGER
                .info("Fazendo chamada para atualizao de grupo corporativo usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .updateEnterpriseGroup(
                        smh,
                        oldId,
                        EnterpriseGroupMounter
                                .mountTransferObject(enterpriseGroup));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER
                .info("Chamada para atualizao de grupo corporativo usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #findAll(br.com.petrobras.security.consume.MessageHeader,
     * java.lang.String)
     */
    public ReturnMessage<List<EnterpriseGroup>> findAll(
            MessageHeader messageHeader, String userLogin) {

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllEnterpriseGroupsOfUser(smh,
                        userLogin);

        // Converte o retorno.
        ReturnMessage<List<EnterpriseGroup>> rm = ReturnMessageMounter
                .mountLocalObjectWithEnterpriseGroupListValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #findAllMembers(br.com.petrobras.security.consume.MessageHeader,
     * java.lang.String, java.lang.Long, java.lang.Long)
     */
    public ReturnMessage<List<User>> findAllMembers(
            MessageHeader messageHeader, String enterpriseGroupId, Long start,
            Long length) {

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllEnterpriseGroupMembership(smh,
                        enterpriseGroupId, start, length);

        // Converte o retorno.
        ReturnMessage<List<User>> rm = ReturnMessageMounter
                .mountLocalObjectWithUserListValue(rmDTO);

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.basic.
     * IEnterpriseGroupManagerConsumer
     * #isMember(br.com.petrobras.security.consume.MessageHeader,
     * java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> isMember(MessageHeader messageHeader,
            String enterpriseGroupId, String userLogin) {

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .verifyEnterpriseGroupMembership(smh, enterpriseGroupId,
                        userLogin);

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        return rm;
    }

    /* [ Operators ] */
}
