/*
 * InformationValueManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.information;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.information.IInformationValueManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.InformationValueMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.InformationValueClassification;
import br.com.petrobras.security.server.service.soap.InformationValueDTO;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Implementao SOAP da interface de consumo para gerenciamento de valores de informao. 
 * 
 * @author Rodrigo Carvalho - UPM7
 *
 */
public class InformationValueManagerConsumerSoapImpl implements
        IInformationValueManagerConsumer {

    private IUserContextIdentifier userContextIdentifier;

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationValueManagerConsumer#findById(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<InformationValue> findById(
            MessageHeader messageHeader, String informationId,
            String informationValueId) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findInformationValueById(smhDTO, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationValueValue(rmDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationValueManagerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<List<InformationValue>> findAll(
            MessageHeader messageHeader, String informationId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllInformationValues(smhDTO, informationId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationValueListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationValueManagerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<List<InformationValue>> findAll(MessageHeader messageHeader, String regionalId, String applicationCatalogId, String informationId) {
		
    	 // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllInformationValuesInRegional(smhDTO, regionalId, applicationCatalogId, informationId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationValueListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
        
	}

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationValueManagerConsumer#findByIds(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.util.List)
     */
    public ReturnMessage<List<InformationValue>> findByIds(
            MessageHeader messageHeader, String informationId,
            List<String> informationValuesIds) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findInformationValuesById(smhDTO, informationId, informationValuesIds);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationValueListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationValueManagerConsumer#findAllInformationValueClassifications(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<InformationValueClassification>> findAllInformationValueClassifications(
            MessageHeader messageHeader) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllInformationValueClassifications(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationValueClassificationListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationValueManagerConsumer#save(br.com.petrobras.security.consume.MessageHeader, br.com.petrobras.security.model.InformationValue)
     */
    public ReturnMessage<Boolean> save(MessageHeader messageHeader,
            InformationValue informationValue) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte o papel local em um papel de transferncia.
        InformationValueDTO informationValueDTO = InformationValueMounter.mountTransferObject(informationValue, 
                this.getUserContextIdentifier().getCurrentUserContext()
                    .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .saveInformationValue(smhDTO, informationValueDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationValueManagerConsumer#update(br.com.petrobras.security.consume.MessageHeader, java.lang.String, br.com.petrobras.security.model.InformationValue)
     */
    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            String oldId, InformationValue informationValue) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte o papel local em um papel de transferncia.
        InformationValueDTO informationValueDTO = InformationValueMounter.mountTransferObject(informationValue, 
                this.getUserContextIdentifier().getCurrentUserContext()
                    .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .updateInformationValue(smhDTO, oldId, informationValueDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationValueManagerConsumer#remove(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<Boolean> remove(MessageHeader messageHeader,
            String informationId, String informationValueId) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .removeInformationValue(smhDTO, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

}
