/*
* AuthenticationLogManagerConsumerSoapImpl
* ----------------------------------
* Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
* ----------------------------------
* Esta classe segue o padro PE-1T0-00315
*/
package br.com.petrobras.security.consume.soap.management.logs;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.log.IAuthenticationLogManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.LogAuthenticationMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.PeriodMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.model.log.LogAuthentication;
import br.com.petrobras.security.model.util.Period;
import br.com.petrobras.security.server.service.soap.*;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: cyh4
 * Date: 04/04/13
 * Time: 17:15
 * To change this template use File | Settings | File Templates.
 */
public class AuthenticationLogManagerConsumerSoapImpl implements IAuthenticationLogManagerConsumer {


    @Override
    public ReturnMessage<List<LogAuthentication>> findByFilter(
            MessageHeader mh, String regionalId, String environmentId, String catalogId, String userLogin,
            Period period, LogAuthentication.EventType eventType, LogAuthentication.AuthenticationType authenticationType,
            LogAuthentication.StatusType statusType) {

        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = null;
        final PeriodDTO periodDTO = PeriodMounter.mountTransferObject(period);
        final EventTypeDTO eventTypeDTO = LogAuthenticationMounter.mountEventTypeTransferObject(eventType);
        final AuthenticationTypeDTO authenticationTypeDTO = LogAuthenticationMounter.mountAuthenticationTypeTransferObject(authenticationType);
        final StatusTypeDTO statusTypeDTO = LogAuthenticationMounter.mountStatusTypeTransferObject(statusType);

        rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAuthenticationLogs(
                        smhDTO,
                        regionalId,
                        environmentId,
                        catalogId,
                        userLogin,
                        periodDTO,
                        eventTypeDTO,
                        authenticationTypeDTO,
                        statusTypeDTO);


        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithLogAuthenticationListValue(rmDTO);


    }
}
