/*
 * ApplicationEnvironmentMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.server.service.soap.ApplicationEnvironmentDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.Locale;

/**
 * Montador de ambientes de aplicaes.
 * 
 * @author JGTL.
 */
public class ApplicationEnvironmentMounter {

    public static ApplicationEnvironment mountLocalObject(ApplicationEnvironmentDTO applicationEnvironmentDTO, Locale preferredUserLanguage) {
        return mountLocalObject (applicationEnvironmentDTO, preferredUserLanguage, true ); 
    }

    public static ApplicationEnvironment mountLocalObject(ApplicationEnvironmentDTO applicationEnvironmentDTO, Locale preferredUserLanguage, Boolean loadAppAndEnv) {
        if (applicationEnvironmentDTO == null) {
            return null;
        } else {
            ApplicationEnvironment applicationEnvironment = new ApplicationEnvironment ();

            applicationEnvironment.setUid(applicationEnvironmentDTO.getUid());
            applicationEnvironment.setLink(applicationEnvironmentDTO.getLink());
            applicationEnvironment.setIntegratedAuthenticationAllowed(applicationEnvironmentDTO.isIntegratedAuthenticationPermited());
            applicationEnvironment.setManagerAuthorized(applicationEnvironmentDTO.isAdministratorAuthorized());
            applicationEnvironment.setLogSynchronous (applicationEnvironmentDTO.isLogSynchronous());
            applicationEnvironment.setReadOnly (applicationEnvironmentDTO.isReadOnly());
            applicationEnvironment.setConsoleAllowed(applicationEnvironmentDTO.isConsoleAuthorized());
            applicationEnvironment.setUserPasswordMustExpire(applicationEnvironmentDTO.isUserPasswordMustExpire());

            applicationEnvironment.setGrcEnabled(applicationEnvironmentDTO.isGrcEnabled());

            if (loadAppAndEnv) {
            	applicationEnvironment.setApplication(ApplicationMounter.mountLocalObject (applicationEnvironmentDTO.getApplication(), preferredUserLanguage ));
                applicationEnvironment.setEnvironment(EnvironmentMounter.mountLocalObject (applicationEnvironmentDTO.getEnvironment(), true ));
            }
            
            return applicationEnvironment;
        }
    }

    /**
     * Monta um ambiente de aplicao de transferncia a partir de um ambiente de aplicao.
     * @param applicationEnvironment Ambiente de aplicao.
     * @return Ambiente de aplicao de transferncia
     */
    public static ApplicationEnvironmentDTO mountTransferObject(ApplicationEnvironment applicationEnvironment) {
        if (applicationEnvironment == null) {
            return null;
        } else {
            ApplicationEnvironmentDTO applicationEnvironmentDTO = new ApplicationEnvironmentDTO ();

            applicationEnvironmentDTO.setUid (applicationEnvironment.getUid());
            applicationEnvironmentDTO.setLink (applicationEnvironment.getLink());
            applicationEnvironmentDTO.setIntegratedAuthenticationPermited (applicationEnvironment.isIntegratedAuthenticationAllowed());
            applicationEnvironmentDTO.setAdministratorAuthorized (applicationEnvironment.isManagerAuthorized());
            applicationEnvironmentDTO.setLogSynchronous(applicationEnvironment.isLogSynchronous());
            applicationEnvironmentDTO.setReadOnly (applicationEnvironment.isReadOnly());
            applicationEnvironmentDTO.setConsoleAuthorized(applicationEnvironment.isConsoleAllowed());
            applicationEnvironmentDTO.setUserPasswordMustExpire(applicationEnvironment.isUserPasswordMustExpire());

            applicationEnvironmentDTO.setGrcEnabled(applicationEnvironment.isGrcEnabled());
            
            try {
                applicationEnvironmentDTO.setCreationDate (DateMounter.mountTransferObject(applicationEnvironment.getCreationDate()));
            } catch(DatatypeConfigurationException dce) {
                applicationEnvironment.setCreationDate(null);
            }

            return applicationEnvironmentDTO;
        }
    }
    
}

