/*
 * ApplicationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.ApplicationDTO;

import java.util.List;
import java.util.Locale;

public class ApplicationMounter {
    
    /**
     * Monta um aplicativo a partir de um aplicativo de transferncia.
     * 
     * @param applicationDTO
     *            Aplicativo de transferncia.
     * @return Aplicativo.
     */
    public static Application mountLocalObject(ApplicationDTO applicationDTO,
            Locale preferredUserLanguage) {
        if (applicationDTO == null) {
            return null;
        } else {
            Application application = new Application();

            // Montagem simples.
            application.setUid(applicationDTO.getUid());
            application.setCatalogId(applicationDTO.getCatalogId());
            
            application.setTechnologies(TechnologyListMounter.mountLocalObject(applicationDTO.getTechnologies()));
            application.setSupportedLanguages(SupportedLanguageListMounter.mountLocalObjectList(applicationDTO.getSupportedLanguages()));

            // Montagem da I18n.
            List<SupportedLanguage> supportedApplicationLanguages = application.getSupportedLanguages();
            application.setCommentTranslations(I18nStringMounter.mountModelObject(applicationDTO.getCommentTranslations(), preferredUserLanguage,supportedApplicationLanguages));
            application.setShortNameTranslations(I18nStringMounter.mountModelObject(applicationDTO.getShortNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            application.setNameTranslations(I18nStringMounter.mountModelObject(applicationDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            application.setDescriptionTranslations(I18nStringMounter.mountModelObject(applicationDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            
            return application;
        }
    }
    
    /**
     * Monta um aplicativo de transferncia a partir de um aplicativo.
     * 
     * @param application
     *            aplicativo.
     * @return aplicativo de transferncia.
     */
    public static ApplicationDTO mountTransferObject(Application application,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (application == null) {
            return null;
        } else {

            if (application.getNameTranslations() == null
                    || application.getNameTranslations().getCount() < 1) {
                throw new IllegalArgumentException(
                        "A lista de tradues de nome do aplicativo est nula ou vazia.");
            }

            if (application.getDescriptionTranslations() == null
                    || application.getDescriptionTranslations().getCount() < 1) {
                throw new IllegalArgumentException(
                        "A lista de tradues de descrio do aplicativo est nula ou vazia.");
            }

            if (application.getShortNameTranslations() == null
                    || application.getShortNameTranslations().getCount() < 1) {
                throw new IllegalArgumentException(
                        "A lista de tradues de apelido do aplicativo est nula ou vazia.");
            }
            
            if (application.getCommentTranslations() == null
                    || application.getCommentTranslations().getCount() < 1) {
                throw new IllegalArgumentException(
                        "A lista de tradues de comentrio do aplicativo est nula ou vazia.");
            }
            
            ApplicationDTO applicationDTO = new ApplicationDTO();

            // Montagem simples.
            applicationDTO.setUid(application.getUid());
            applicationDTO.setCatalogId(application.getCatalogId());
            
            // Montagem complexa.
            
            applicationDTO.getTechnologies().addAll(TechnologyListMounter.mountTransferObject(application.getTechnologies()));
            applicationDTO.getSupportedLanguages().addAll(SupportedLanguageListMounter.mountTransferObject(application.getSupportedLanguages()));

            // Montagem da I18n.
            applicationDTO.setNameTranslations(I18nStringMounter.mountTransferObject(
                    application.getNameTranslations(), supportedApplicationLanguages));
            applicationDTO.setDescriptionTranslations(I18nStringMounter
                    .mountTransferObject(application.getDescriptionTranslations(),
                            supportedApplicationLanguages));
            applicationDTO.setShortNameTranslations(I18nStringMounter.mountTransferObject(
                    application.getShortNameTranslations(), supportedApplicationLanguages));
            applicationDTO.setCommentTranslations(I18nStringMounter.mountTransferObject(
                    application.getCommentTranslations(), supportedApplicationLanguages));
            
            return applicationDTO;
        }
    }
}

