 /*
 * CompanyListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.Company;
 import br.com.petrobras.security.server.service.soap.CompanyDTO;

 import java.util.ArrayList;
 import java.util.List;

/**
 * Montador de lista de empresas.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class CompanyListMounter {

    /**
     * Monta uma lista empresas a partir de uma lista de empresas de transferncia.
     * 
     * @param companyListDTO Lista de empresas de transferncias.
     * @return Lista de empresas.
     */
    public static List<Company> mountLocalObject(List<Object> companyListDTO) {
        if (companyListDTO == null) {
            return null;
        }
        
        List<Company> companyList = new ArrayList<Company>();
        
        for (Object objectCompanyDTO : companyListDTO) {
            CompanyDTO companyDTO = (CompanyDTO) objectCompanyDTO;
            companyList.add(CompanyMounter.mountLocalObject(companyDTO));
        }
        
        return companyList;
    }

}
