 /*
 * EnterpriseGroupInformationValueAuthorizationListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.authorization.information.EnterpriseGroupInformationValueAuthorization;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupInformationValueAuthorizationDTO;

 import java.util.ArrayList;
 import java.util.List;
 import java.util.Locale;

/**
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class EnterpriseGroupInformationValueAuthorizationListMounter {

    public static List<EnterpriseGroupInformationValueAuthorization> mountLocalObjectList(
            List<Object> enterpriseGroupInformationValueAuthorizationListDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (enterpriseGroupInformationValueAuthorizationListDTO == null) {
            return null;
        } else {
            List<EnterpriseGroupInformationValueAuthorization> enterpriseGroupInformationValueAuthorizationList = new ArrayList<EnterpriseGroupInformationValueAuthorization>();

            for (Object objectEnterpriseGroupInformationValueAuthorizationDTO : enterpriseGroupInformationValueAuthorizationListDTO) {
                EnterpriseGroupInformationValueAuthorizationDTO enterpriseGroupInformationValueAuthorizationDTO = (EnterpriseGroupInformationValueAuthorizationDTO) objectEnterpriseGroupInformationValueAuthorizationDTO;

                enterpriseGroupInformationValueAuthorizationList
                        .add(EnterpriseGroupInformationValueAuthorizationMounter
                                .mountLocalObject(
                                        enterpriseGroupInformationValueAuthorizationDTO,
                                        preferredUserLanguage,
                                        supportedApplicationLanguages));
            }

            return enterpriseGroupInformationValueAuthorizationList;
        }
    }
    
}
