/*
 * EnvironmentMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.server.service.soap.EnvironmentDTO;

import javax.xml.datatype.DatatypeConfigurationException;

/**
 * Montador de ambientes.
 * 
 * @author DMMD
 */
public class EnvironmentMounter {

    public static Environment mountLocalObject(EnvironmentDTO environmentDTO) {
        return mountLocalObject(environmentDTO, true);
    }

    public static Environment mountLocalObject(EnvironmentDTO environmentDTO,
            boolean loadRegional) {
        if (environmentDTO == null) {
            return null;
        } else {
            Environment environment = new Environment();

            // Montagem simples.
            environment.setUid(environmentDTO.getUid());
            environment.setDescription(environmentDTO.getDescription());
            environment.setId(environmentDTO.getId());

            environment.setName(environmentDTO.getName());
            environment.setDescription(environmentDTO.getDescription());
            environment.setReadOnly(environmentDTO.isReadOnly());

            environment.setCreationDate(DateMounter
                    .mountLocalObject(environmentDTO.getCreationDate()));

            if (loadRegional) {
                environment.setRegional(RegionalMounter
                        .mountLocalObject(environmentDTO.getRegional()));
            }

            return environment;
        }
    }

    /**
     * Monta um ambiente de transferncia a partir de um ambiente.
     * 
     * @param environment
     *            Regional.
     * @return regional de transferncia.
     */

    public static EnvironmentDTO mountTransferObject(Environment environment) {
        if (environment == null) {
            return null;
        } else {
            EnvironmentDTO environmentDTO = new EnvironmentDTO();

            // Montagem simples.
            environmentDTO.setUid(environment.getUid());
            environmentDTO.setId(environment.getId());
            environmentDTO.setDescription(environment.getDescription());
            environmentDTO.setName(environment.getName());
            environmentDTO.setReadOnly(environment.isReadOnly());

            environmentDTO.setRegional(RegionalMounter
                    .mountTransferObject(environment.getRegional()));

            try {
                environmentDTO.setCreationDate(DateMounter
                        .mountTransferObject(environment.getCreationDate()));
            } catch (DatatypeConfigurationException dtce) {
                throw new InvalidOperationException(
                        "No foi possvel converter a data de cadastro do caso de uso para enviar ao servio. "
                                + dtce.getMessage());
            }

            return environmentDTO;
        }
    }

}

