/*
 * InformationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Information;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.InformationDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.List;
import java.util.Locale;

/**
 * Montador de informaes.
 * 
 * @author UPM7
 *
 */
public class InformationMounter {

    /**
     * Monta um papel a partir de um papel de transferncia.
     * 
     * @param informationDTO
     *            Papel de transferncia.
     * @param supportedApplicationLanguages 
     * @return Papel.
     */
    public static Information mountLocalObject(InformationDTO informationDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (informationDTO == null) {
            return null;
        } else {
            Information information = new Information();

            // Montagem simples.
            information.setUid(informationDTO.getUid());
            information.setId(informationDTO.getId());
            information.setEnabled(informationDTO.isEnabled());
            information.setCreationDate(DateMounter.mountLocalObject(informationDTO.getCreationDate()));
            information.setContext(informationDTO.isContext());

            // Montagem complexa.
            information.setApplicationEnvironment(ApplicationEnvironmentMounter.mountLocalObject(
                    informationDTO.getApplicationEnvironment(), preferredUserLanguage));

            information.setExpiration(ExpirationMounter.mountLocalObject(informationDTO.getExpiration()));
            information.setSharingType(InformationSharingTypeMounter.mountLocalObject(
                    informationDTO.getSharingType(), preferredUserLanguage, supportedApplicationLanguages));
            
            // Montagem da I18n.
            information.setNameTranslations(I18nStringMounter.mountModelObject(informationDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            information.setDescriptionTranslations(I18nStringMounter.mountModelObject(informationDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));

            return information;
        }
    }

    /**
     * Monta um papel de transferncia a partir de um papel.
     * 
     * @param information
     *            Informacao
     * @param supportedApplicationLanguages
     *            Idiomas suportados pela aplicacao.
     * @return Informacao de transferncia.
     */
    public static InformationDTO mountTransferObject(Information information, List<SupportedLanguage> supportedApplicationLanguages) {
        if (information == null) {
            return null;
        } else {

            InformationDTO informationDTO = new InformationDTO();

            // Montagem simples.
            informationDTO.setUid(information.getUid());
            informationDTO.setId(information.getId());
            informationDTO.setEnabled(information.isEnabled());
            informationDTO.setContext(information.isContext());

            try {
                informationDTO.setCreationDate(DateMounter.mountTransferObject(information
                        .getCreationDate()));
            } catch (DatatypeConfigurationException dtce) { /* nao precisa fazer nada */ }

            // Montagem complexa.
            informationDTO.setExpiration(ExpirationMounter.mountTransferObject(information
                    .getExpiration()));
            informationDTO.setSharingType(InformationSharingTypeMounter.mountTransferObject(information.getSharingType()));
            informationDTO.setApplicationEnvironment(ApplicationEnvironmentMounter.mountTransferObject(information.getApplicationEnvironment()));

            
            // Montagem da I18n.
            informationDTO.setNameTranslations(I18nStringMounter.mountTransferObject(
                    information.getNameTranslations(), supportedApplicationLanguages));
            informationDTO.setDescriptionTranslations(I18nStringMounter.mountTransferObject(
                    information.getDescriptionTranslations(), supportedApplicationLanguages));
            
            return informationDTO;
        }
    }
    
    public static InformationDTO mountTransferObject(Information information) {
        return mountTransferObject(information, null);
    }

}
