/*
 * InformationValueMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.InformationValueDTO;

import java.util.List;
import java.util.Locale;

public class InformationValueMounter {

    /**
     * @param informationValue Objeto de modelo
     * @return Objeto de transferencia
     */
    public static InformationValueDTO mountTransferObject(
            InformationValue informationValue, List<SupportedLanguage> supportedApplicationLanguages) {

        if (informationValue == null) {
            return null;
        } else {

            InformationValueDTO dto = new InformationValueDTO();
            dto.setUid(informationValue.getUid());
            dto.setId(informationValue.getId());
            dto.setEnabled(informationValue.isEnabled());

            dto.setNameTranslations(I18nStringMounter.mountTransferObject(
                    informationValue.getNameTranslations(), supportedApplicationLanguages));
            dto.setDescriptionTranslations(I18nStringMounter.mountTransferObject(
                    informationValue.getDescriptionTranslations(), supportedApplicationLanguages));
            
            dto.setExpiration(ExpirationMounter.mountTransferObject(
                    informationValue.getExpiration()));
            dto.setInformation(InformationMounter.mountTransferObject(
                    informationValue.getInformation(),supportedApplicationLanguages));
            dto.setClassification(InformationValueClassificationMounter.mountTransferObject(
                    informationValue.getClassification()));
            dto.setArea(AreaMounter.mountTransferObject(informationValue.getArea(), supportedApplicationLanguages));
            return dto;
        }
    }

    public static InformationValue mountLocalObject(
            InformationValueDTO informationValueDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (informationValueDTO == null) { return null; }
        else {
            InformationValue informationValue = new InformationValue();

            informationValue.setUid(informationValueDTO.getUid());

            informationValue.setId(informationValueDTO.getId());
            informationValue.setEnabled(informationValueDTO.isEnabled());

            // Montagem complexa.
            informationValue.setExpiration(ExpirationMounter.mountLocalObject(informationValueDTO.getExpiration()));
            informationValue.setClassification(InformationValueClassificationMounter.mountLocalObject(
                    informationValueDTO.getClassification(), preferredUserLanguage, supportedApplicationLanguages));
            informationValue.setInformation(InformationMounter.mountLocalObject(
                    informationValueDTO.getInformation(), preferredUserLanguage, supportedApplicationLanguages));
            informationValue.setArea(AreaMounter.mountLocalObject(informationValueDTO.getArea(), 
            		preferredUserLanguage, supportedApplicationLanguages));

            // Montagem da I18n.
            informationValue.setNameTranslations(I18nStringMounter.mountModelObject(
                    informationValueDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            informationValue.setDescriptionTranslations(I18nStringMounter.mountModelObject(
                    informationValueDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));

            return informationValue;
        }
    }

}
