/*
* @(#)RoleTypeListMounter.java
*
*/
/*
 * RoleTypeListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.RoleType;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleTypeDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Montador de lista de tipos de papel.
 *
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 *
 */
public class RoleTypeListMounter {

    /**
     * Monta uma lista de tipos de papel a partir de uma lista de transferncia.
     * @param roleTypeListDTO Lista de transferncia.
     * @return Lista de tipos de papel.
     */
    public static List<RoleType> mountLocalObjectList (List<Object> roleTypeListDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages  )
    {
        if (roleTypeListDTO == null ) { return null; }
        else
        {
            List<RoleType> roleTypeList = new ArrayList<RoleType> ();

            for (Object objectDTO : roleTypeListDTO) {
                RoleTypeDTO roleTypeDTO = (RoleTypeDTO)objectDTO;
                roleTypeList.add(RoleTypeMounter.mountLocalObject(roleTypeDTO, preferredUserLanguage, supportedApplicationLanguages));
            }
            
            return roleTypeList;
        }
    }
}

