/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.access;

import br.com.petrobras.security.ISecurityContext;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.access.role.FindAllRoleTypesCommand;
import br.com.petrobras.security.command.management.access.role.FindAllRolesCommand;
import br.com.petrobras.security.command.management.access.role.FindRoleByIdCommand;
import br.com.petrobras.security.command.management.access.role.FindRolesByIdsCommand;
import br.com.petrobras.security.command.management.access.role.RemoveRoleByIdCommand;
import br.com.petrobras.security.command.management.access.role.SaveRoleCommand;
import br.com.petrobras.security.command.management.access.role.UpdateRoleCommand;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.access.IRoleManager;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.RoleType;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class RoleManagerCoreImpl
implements IRoleManager {
    public void save(Role role) throws InvalidArgumentException, PermissionDeniedException, ConstraintViolationException, SecurityException {
        SaveRoleCommand cmd = ICommandIdentifier.getInstance().getSaveRoleCommand();
        cmd.setRoleArg(role);
        cmd.execute();
    }

    public void update(String oldRoleId, Role newRoleToUpdate) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        UpdateRoleCommand cmd = ICommandIdentifier.getInstance().getUpdateRoleCommand();
        cmd.setOldRoleIdArg(oldRoleId);
        cmd.setRoleArg(newRoleToUpdate);
        cmd.execute();
    }

    public void update(Role role) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        UpdateRoleCommand cmd = ICommandIdentifier.getInstance().getUpdateRoleCommand();
        cmd.setRoleArg(role);
        cmd.execute();
    }

    public void remove(Role role) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.remove(role.getId());
    }

    public void remove(String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        RemoveRoleByIdCommand cmd = ICommandIdentifier.getInstance().getRemoveRoleByIdCommand();
        cmd.setRoleIdArg(roleId);
        cmd.execute();
    }

    public Role find(String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindRoleByIdCommand cmd = ICommandIdentifier.getInstance().getFindRoleByIdCommand();
        cmd.setRoleIdArg(roleId);
        return (Role)cmd.execute();
    }

    public List<Role> find(List<String> roleIds) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindRolesByIdsCommand cmd = ICommandIdentifier.getInstance().getFindRolesByIdsCommand();
        cmd.setRoleIdsArg(roleIds);
        return (List)cmd.execute();
    }

    public List<Role> findAll() throws PermissionDeniedException, SecurityException {
        return this.findAll(ISecurityContext.getContext().getCurrentArea().getId());
    }

    public List<Role> findAll(String areaId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllRolesCommand cmd = ICommandIdentifier.getInstance().getFindAllRolesCommand();
        cmd.setTargetAreaIdArg(areaId);
        return (List)cmd.execute();
    }

    public List<Role> findAll(Area area) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        return this.findAll(area.getId());
    }

    public List<RoleType> findAllTypes() throws PermissionDeniedException, SecurityException {
        FindAllRoleTypesCommand cmd = ICommandIdentifier.getInstance().getFindAllRoleTypesCommand();
        return (List)cmd.execute();
    }
}

