/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.ISecurityContext;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.userrole.AddContextToUserRoleAuthorizationCommand;
import br.com.petrobras.security.command.management.authorization.userrole.FindAllContextValueSetsOfUserRoleAuthorizationCommand;
import br.com.petrobras.security.command.management.authorization.userrole.FindAllUserRoleAuthorizationsOfRoleByIdAndContextValueSetCommand;
import br.com.petrobras.security.command.management.authorization.userrole.FindAllUserRoleAuthorizationsOfRoleByIdCommand;
import br.com.petrobras.security.command.management.authorization.userrole.FindAllUsersOfRoleByIdAndContextValueSetCommand;
import br.com.petrobras.security.command.management.authorization.userrole.FindAllUsersOfRoleCommand;
import br.com.petrobras.security.command.management.authorization.userrole.FindUserRolesCommand;
import br.com.petrobras.security.command.management.authorization.userrole.GrantRoleAuthorizationToUserCommand;
import br.com.petrobras.security.command.management.authorization.userrole.RemoveContextFromUserRoleAuthorizationCommand;
import br.com.petrobras.security.command.management.authorization.userrole.RevokeRoleAuthorizationFromUserCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IUserRoleAuthorizationManager;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.IContextValue;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.model.authorization.access.UserRoleAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.ArrayList;
import java.util.List;

public class UserRoleAuthorizationManagerCoreImpl
implements IUserRoleAuthorizationManager {
    public List<UserRoleAuthorization> findAllWithRole(Role role) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        return this.findAllWithRole(role.getId(), (String)null);
    }

    public List<UserRoleAuthorization> findAllWithRole(String roleId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        return this.findAllWithRole(roleId, (String)null);
    }

    public List<UserRoleAuthorization> findAllWithRole(Role role, Area area) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        return this.findAllWithRole(role.getId(), area.getId());
    }

    public List<UserRoleAuthorization> findAllWithRole(String roleId, String areaId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllUserRoleAuthorizationsOfRoleByIdCommand cmd = ICommandIdentifier.getInstance().getFindAllUserRoleAuthorizationsOfRoleByIdCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setTargetAreaIdArg(areaId);
        return (List)cmd.execute();
    }

    public List<UserRoleAuthorization> findAllWithRole(Role role, IContextValue contextValue) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)contextValue);
        return this.findAllWithRole(role.getId(), null, contextValue.getContext().getId(), contextValue.getId());
    }

    public List<UserRoleAuthorization> findAllWithRole(String roleId, String contextId, String contextValueId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        return this.findAllWithRole(roleId, null, contextId, contextValueId);
    }

    public List<UserRoleAuthorization> findAllWithRole(Role role, Area area, IContextValue contextValue) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)contextValue);
        return this.findAllWithRole(role.getId(), area.getId(), contextValue.getContext().getId(), contextValue.getId());
    }

    public List<UserRoleAuthorization> findAllWithRole(String roleId, String areaId, String contextId, String contextValueId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllUserRoleAuthorizationsOfRoleByIdAndContextValueSetCommand cmd = ICommandIdentifier.getInstance().getFindAllUserRoleAuthorizationsOfRoleByIdAndContextValueSetCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setTargetAreaIdArg(areaId);
        cmd.setContextValueSet(new ContextValueSet(new String[]{contextId}, new String[]{contextValueId}));
        return (List)cmd.execute();
    }

    public List<UserRoleAuthorization> findAllWithRole(Role role, ContextValueSet contextValueSet) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)contextValueSet);
        return this.findAllWithRole(role.getId(), null, contextValueSet);
    }

    public List<UserRoleAuthorization> findAllWithRole(String roleId, ContextValueSet contextValueSet) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)contextValueSet);
        return this.findAllWithRole(roleId, null, contextValueSet);
    }

    public List<UserRoleAuthorization> findAllWithRole(Role role, Area area, ContextValueSet contextValueSet) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)contextValueSet);
        return this.findAllWithRole(role.getId(), area.getId(), contextValueSet);
    }

    public List<UserRoleAuthorization> findAllWithRole(String roleId, String areaId, ContextValueSet contextValueSet) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)contextValueSet);
        FindAllUserRoleAuthorizationsOfRoleByIdAndContextValueSetCommand cmd = ICommandIdentifier.getInstance().getFindAllUserRoleAuthorizationsOfRoleByIdAndContextValueSetCommand();
        cmd.setTargetAreaIdArg(areaId);
        cmd.setRoleIdArg(roleId);
        cmd.setContextValueSet(contextValueSet);
        return (List)cmd.execute();
    }

    public List<User> findAllUsersWithRole(String roleId, ContextValueSet contextValueSet) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)contextValueSet);
        FindAllUsersOfRoleByIdAndContextValueSetCommand cmd = ICommandIdentifier.getInstance().getFindAllUsersOfRoleByIdAndContextValueSetCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setContextValueSet(contextValueSet);
        return (List)cmd.execute();
    }

    public List<User> findAllUsersWithRole(String roleId, String contextId, String contextValueId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        return this.findAllUsersWithRole(roleId, new ContextValueSet(new String[]{contextId}, new String[]{contextValueId}));
    }

    public List<User> findAllUsersWithRole(String roleId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllUsersOfRoleCommand cmd = ICommandIdentifier.getInstance().getFindAllUsersOfRoleCommand();
        cmd.setRoleIdArg(roleId);
        return (List)cmd.execute();
    }

    public List<Role> findUserRoles(User user) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        return this.findUserRoles(user.getLogin());
    }

    public List<Role> findUserRoles(User user, Area area) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        return this.findUserRoles(user.getLogin(), area.getId());
    }

    public List<Role> findUserRoles(String userLogin) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        return this.findUserRoles(userLogin, ISecurityContext.getContext().getCurrentArea().getId());
    }

    public List<Role> findUserRoles(String userLogin, String areaId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        FindUserRolesCommand cmd = ICommandIdentifier.getInstance().getFindUserRolesCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setTargetAreaIdArg(areaId);
        return (List)cmd.execute();
    }

    public List<Role> findCurrentUserRoles() throws PermissionDeniedException, InvalidOperationException, SecurityException {
        FindUserRolesCommand cmd = ICommandIdentifier.getInstance().getFindUserRolesCommand();
        cmd.setTargetAreaIdArg(ISecurityContext.getContext().getCurrentArea().getId());
        return (List)cmd.execute();
    }

    public void grant(User user, Role role) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.grant(user.getLogin(), role.getId());
    }

    public void grant(String userLogin, String roleId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantRoleAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getGrantRoleAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setRoleIdArg(roleId);
        cmd.execute();
    }

    public void revoke(User user, Role role) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.revoke(user.getLogin(), role.getId(), (String)null);
    }

    public void revoke(String userLogin, String roleId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.revoke(userLogin, roleId, (String)null);
    }

    public void revoke(User user, Role role, Area area) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        this.revoke(user.getLogin(), role.getId(), area.getId());
    }

    public void revoke(String userLogin, String roleId, String areaId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeRoleAuthorizationFromUserCommand cmd = ICommandIdentifier.getInstance().getRevokeRoleAuthorizationFromUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setRoleIdArg(roleId);
        cmd.setTargetAreaIdArg(areaId);
        cmd.execute();
    }

    public void grant(User user, Role role, Area area) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        this.grant(user.getLogin(), role.getId(), area.getId());
    }

    public void grant(String userLogin, String roleId, String areaId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantRoleAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getGrantRoleAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setRoleIdArg(roleId);
        cmd.setTargetAreaIdArg(areaId);
        cmd.execute();
    }

    public void grant(User user, Role role, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.grant(user.getLogin(), role.getId(), contextValueSets);
    }

    public void grant(String userLogin, String roleId, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.grant(userLogin, roleId, ISecurityContext.getContext().getCurrentArea().getId(), contextValueSets);
    }

    public void grant(User user, Role role, Area area, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        this.grant(user.getLogin(), role.getId(), area.getId(), contextValueSets);
    }

    public void grant(String userLogin, String roleId, String areaId, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantRoleAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getGrantRoleAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setRoleIdArg(roleId);
        cmd.setTargetAreaIdArg(areaId);
        cmd.setContextValueSets(contextValueSets);
        cmd.execute();
    }

    public void grant(User user, Role role, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.grant(user, role, this.loadSet(contextValueSet));
    }

    public void grant(String userLogin, String roleId, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.grant(userLogin, roleId, this.loadSet(contextValueSet));
    }

    public void grant(User user, Role role, Area area, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.grant(user, role, area, this.loadSet(contextValueSet));
    }

    public void grant(String userLogin, String roleId, String areaId, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.grant(userLogin, roleId, areaId, this.loadSet(contextValueSet));
    }

    public List<ContextValueSet> findAllContextValueSets(String userLogin, String roleId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        FindAllContextValueSetsOfUserRoleAuthorizationCommand cmd = ICommandIdentifier.getInstance().getFindAllContextValueSetsOfUserRoleAuthorizationCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setUserLoginArg(userLogin);
        return (List)cmd.execute();
    }

    public List<ContextValueSet> findAllContextValueSets(User user, Role role) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        return this.findAllContextValueSets(user.getLogin(), role.getId());
    }

    public void addContext(String userLogin, String roleId, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.addContext(userLogin, roleId, ISecurityContext.getContext().getCurrentArea().getId(), contextValueSets);
    }

    public void addContext(String userLogin, String roleId, String areaId, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        AddContextToUserRoleAuthorizationCommand cmd = ICommandIdentifier.getInstance().getAddContextToUserRoleAuthorizationCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setUserLoginArg(userLogin);
        cmd.setTargetAreaIdArg(areaId);
        cmd.setContextValueSetsArg(contextValueSets);
        cmd.execute();
    }

    public void addContext(User user, Role role, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.addContext(user.getLogin(), role.getId(), contextValueSets);
    }

    public void addContext(User user, Role role, Area area, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        this.addContext(user.getLogin(), role.getId(), area.getId(), contextValueSets);
    }

    public void addContext(String userLogin, String roleId, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.addContext(userLogin, roleId, this.loadSet(contextValueSet));
    }

    public void addContext(String userLogin, String roleId, String areaId, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.addContext(userLogin, roleId, areaId, this.loadSet(contextValueSet));
    }

    public void addContext(User user, Role role, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.addContext(user, role, this.loadSet(contextValueSet));
    }

    public void addContext(User user, Role role, Area area, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.addContext(user, role, area, this.loadSet(contextValueSet));
    }

    public void removeContext(String userLogin, String roleId, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.removeContext(userLogin, roleId, null, contextValueSets);
    }

    public void removeContext(String userLogin, String roleId, String areaId, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RemoveContextFromUserRoleAuthorizationCommand cmd = ICommandIdentifier.getInstance().getRemoveContextFromUserRoleAuthorizationCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setUserLoginArg(userLogin);
        cmd.setTargetAreaIdArg(areaId);
        cmd.setContextValueSetsArg(contextValueSets);
        cmd.execute();
    }

    public void removeContext(User user, Role role, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.removeContext(user.getLogin(), role.getId(), null, contextValueSets);
    }

    public void removeContext(User user, Role role, Area area, List<ContextValueSet> contextValueSets) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        this.removeContext(user.getLogin(), role.getId(), area.getId(), contextValueSets);
    }

    public void removeContext(String userLogin, String roleId, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.removeContext(userLogin, roleId, null, this.loadSet(contextValueSet));
    }

    public void removeContext(String userLogin, String roleId, String areaId, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        this.removeContext(userLogin, roleId, areaId, this.loadSet(contextValueSet));
    }

    public void removeContext(User user, Role role, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.removeContext(user.getLogin(), role.getId(), null, this.loadSet(contextValueSet));
    }

    public void removeContext(User user, Role role, Area area, ContextValueSet contextValueSet) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        this.removeContext(user.getLogin(), role.getId(), area.getId(), this.loadSet(contextValueSet));
    }

    private List<ContextValueSet> loadSet(ContextValueSet contextValueSet) {
        ArrayList<ContextValueSet> sets = new ArrayList<ContextValueSet>();
        sets.add(contextValueSet);
        return sets;
    }
}

