/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.information;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.information.informationvalue.FindAllInformationValueClassificationsCommand;
import br.com.petrobras.security.command.management.information.informationvalue.FindAllInformationValuesCommand;
import br.com.petrobras.security.command.management.information.informationvalue.FindAllInformationValuesInRegionalCommand;
import br.com.petrobras.security.command.management.information.informationvalue.FindInformationValueByIdCommand;
import br.com.petrobras.security.command.management.information.informationvalue.FindInformationValuesByIdCommand;
import br.com.petrobras.security.command.management.information.informationvalue.RemoveInformationValueCommand;
import br.com.petrobras.security.command.management.information.informationvalue.SaveInformationValueCommand;
import br.com.petrobras.security.command.management.information.informationvalue.UpdateInformationValueCommand;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.information.IInformationValueManager;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.InformationValueClassification;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class InformationValueManagerCoreImpl
implements IInformationValueManager {
    public InformationValue find(String informationId, String informationValueId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindInformationValueByIdCommand cmd = ICommandIdentifier.getInstance().getFindInformationValueByIdCommand();
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        return (InformationValue)cmd.execute();
    }

    public List<InformationValue> find(String informationId, List<String> informationValueIds) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindInformationValuesByIdCommand cmd = ICommandIdentifier.getInstance().getFindInformationValuesByIdCommand();
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValuesIdsToFindArg(informationValueIds);
        return (List)cmd.execute();
    }

    public List<InformationValue> findAll(String informationId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllInformationValuesCommand cmd = ICommandIdentifier.getInstance().getFindAllInformationValuesCommand();
        cmd.setInformationIdArg(informationId);
        return (List)cmd.execute();
    }

    public List<InformationValueClassification> findAllClassifications() {
        FindAllInformationValueClassificationsCommand cmd = ICommandIdentifier.getInstance().getFindAllInformationValueClassificationsCommand();
        return (List)cmd.execute();
    }

    public void save(InformationValue informationValue) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        SaveInformationValueCommand cmd = ICommandIdentifier.getInstance().getSaveInformationValueCommand();
        cmd.setInformationValueArg(informationValue);
        cmd.execute();
    }

    public void update(InformationValue informationValue) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        this.update(informationValue.getId(), informationValue);
    }

    public void update(String oldId, InformationValue informationValue) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        UpdateInformationValueCommand cmd = ICommandIdentifier.getInstance().getUpdateInformationValueCommand();
        cmd.setOldIdArg(oldId);
        cmd.setInformationValueArg(informationValue);
        cmd.execute();
    }

    public void remove(InformationValue informationValue) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        this.remove(informationValue.getInformation().getId(), informationValue.getId());
    }

    public void remove(String informationId, String informationValueId) throws InvalidArgumentException, ConstraintViolationException, InvalidOperationException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        RemoveInformationValueCommand cmd = ICommandIdentifier.getInstance().getRemoveInformationValueCommand();
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public List<InformationValue> findAll(String regionalId, String applicationCatalogId, String informationId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllInformationValuesInRegionalCommand cmd = ICommandIdentifier.getInstance().getFindAllInformationValuesInRegionalCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        return (List)cmd.execute();
    }
}

