/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.exception;

import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.ExceptionInfo;
import br.com.petrobras.security.exception.ExpiredPasswordException;
import br.com.petrobras.security.exception.InactivatedApplicationEnvironmentException;
import br.com.petrobras.security.exception.InactivatedUseCaseException;
import br.com.petrobras.security.exception.InactivatedUserException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidCredentialsException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.ReadOnlyApplicationEnvironmentException;
import br.com.petrobras.security.exception.ReadOnlyEnvironmentException;
import br.com.petrobras.security.exception.ReadOnlyRegionalException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.exception.TranslationNotFoundException;
import br.com.petrobras.security.exception.UnknownSecurityException;
import java.io.Serializable;

public class ExceptionHandler
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static void handle(ExceptionInfo exceptionInfo) throws SecurityException {
        if (exceptionInfo != null) {
            switch (exceptionInfo.getCode()) {
                case 101: {
                    throw new InvalidCredentialsException(exceptionInfo.getMessage());
                }
                case 102: {
                    throw new PermissionDeniedException(exceptionInfo.getMessage());
                }
                case 103: {
                    throw new InvalidOperationException(exceptionInfo.getMessage());
                }
                case 202: {
                    throw new TranslationNotFoundException(exceptionInfo.getMessage());
                }
                case 201: {
                    throw new ObjectNotFoundException(exceptionInfo.getMessage());
                }
                case 210: {
                    throw new ConstraintViolationException(exceptionInfo.getMessage());
                }
                case 301: {
                    throw new InactivatedApplicationEnvironmentException(exceptionInfo.getMessage());
                }
                case 302: {
                    throw new InactivatedUserException(exceptionInfo.getMessage());
                }
                case 303: {
                    throw new InactivatedUseCaseException(exceptionInfo.getMessage());
                }
                case 105: {
                    throw new ExpiredPasswordException(exceptionInfo.getMessage());
                }
                case 104: {
                    throw new InvalidArgumentException(exceptionInfo.getMessage());
                }
                case 108: {
                    throw new ReadOnlyRegionalException(exceptionInfo.getMessage());
                }
                case 109: {
                    throw new ReadOnlyEnvironmentException(exceptionInfo.getMessage());
                }
                case 106: {
                    throw new ReadOnlyApplicationEnvironmentException(exceptionInfo.getMessage());
                }
            }
            throw new UnknownSecurityException(exceptionInfo.getMessage());
        }
        throw new NullPointerException("Informa\u00e7\u00e3o da exce\u00e7\u00e3o n\u00e3o informada.");
    }
}

