/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.model;

import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.model.IContextValue;
import br.com.petrobras.security.model.Information;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.authorization.IAuthorizationContextValue;
import br.com.petrobras.security.model.authorization.access.UserRoleAuthorizationContextInformationValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ContextValueSet
implements Serializable {
    private static final long serialVersionUID = -9041096445279540223L;
    private Long uid;
    private List<IAuthorizationContextValue> authorizationContextValues = new ArrayList<IAuthorizationContextValue>();

    public ContextValueSet() {
    }

    public ContextValueSet(String[] contexts, String[] contextValues) {
        if (contexts == null || contextValues == null) {
            throw new InvalidArgumentException("Contexto(s) e/ou valor(es) de contexto(s) \u00e9 (s\u00e3o) nulo(s).");
        }
        if (contexts.length != contextValues.length) {
            throw new InvalidArgumentException("Quantidade de contextos \u00e9 diferente da quantidade de valores de contexto.");
        }
        for (int i = 0; i < contexts.length; ++i) {
            this.addContextValue(new InformationValue(contextValues[i], new Information(contexts[i])));
        }
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public ContextValueSet(IContextValue ... contextValues) {
        if (contextValues != null) {
            for (IContextValue contextValue : contextValues) {
                this.addContextValue(contextValue);
            }
        }
    }

    public List<IAuthorizationContextValue> getAuthorizationContextValues() {
        if (this.authorizationContextValues == null) {
            this.authorizationContextValues = new ArrayList<IAuthorizationContextValue>();
        }
        return this.authorizationContextValues;
    }

    public void setAuthorizationContextValues(List<IAuthorizationContextValue> authorizationContextValues) {
        this.authorizationContextValues = authorizationContextValues;
    }

    public void addContextValue(IContextValue contextValue) {
        if (!(contextValue instanceof InformationValue)) {
            throw new UnsupportedOperationException("Tipo de valor de contexto n\u00e3o suportado. Talvez seja preciso atualizar a API.");
        }
        UserRoleAuthorizationContextInformationValue authorizationContextValue = new UserRoleAuthorizationContextInformationValue();
        authorizationContextValue.setContextValue(contextValue);
        this.getAuthorizationContextValues().add(authorizationContextValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if ((obj == null || obj.getClass() != this.getClass()) && obj.getClass().getSuperclass() != this.getClass()) {
            return false;
        }
        ContextValueSet other = (ContextValueSet)obj;
        return this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.getUid() != null) {
            return builder.append((Object)this.getUid()).toHashCode();
        }
        if (this.getAuthorizationContextValues() != null && this.getAuthorizationContextValues().size() > 0) {
            Collections.sort(this.getAuthorizationContextValues());
            for (IAuthorizationContextValue contextValue : this.getAuthorizationContextValues()) {
                if (contextValue != null && contextValue.getUid() != null) {
                    builder.append((Object)contextValue.getUid());
                    continue;
                }
                builder.append((Object)contextValue.getContextValue());
            }
            return builder.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

