/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.model.i18n;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.TranslationNotFoundException;
import br.com.petrobras.security.model.i18n.I18nUtil;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class I18nString
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int INDEX_PREFERRED_LANGUAGE = 0;
    private static final String PREFERRED_LANGUAGE_CODE = "PREFERRED_LANGUAGE_CODE";
    private LinkedHashMap<String, String> translations = new LinkedHashMap();
    private String preferredLanguageCode = null;
    private String preferredTranslation = null;
    private boolean hasApplicationMoreThenOneLanguages = false;

    public I18nString() {
    }

    public I18nString(AbstractMap<String, String> translations, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (translations == null) {
            throw new NullPointerException("Tradu\u00e7\u00f5es est\u00e3o nulas.");
        }
        this.hasApplicationMoreThenOneLanguages = supportedApplicationLanguages.size() > 1;
        String preferredUserLanguageCode = I18nUtil.convertLocaleToLanguageCode(preferredUserLanguage);
        String preferredLanguageToThisTranslations = null;
        if (translations.containsKey(preferredUserLanguageCode)) {
            preferredLanguageToThisTranslations = preferredUserLanguageCode;
        } else {
            for (SupportedLanguage supportedLanguage : supportedApplicationLanguages) {
                if (supportedLanguage.getPreference() != 0L) continue;
                preferredLanguageToThisTranslations = supportedLanguage.getLocale().getLanguageCode();
                break;
            }
        }
        for (String languageCode : translations.keySet()) {
            if (languageCode.equals(preferredLanguageToThisTranslations)) {
                this.preferredTranslation = translations.get(languageCode);
                this.preferredLanguageCode = languageCode;
            }
            this.translations.put(languageCode, translations.get(languageCode));
        }
    }

    public I18nString(Locale[] locales, String[] translations) {
        if (locales == null || translations == null) {
            throw new NullPointerException("Idioma(s) e/ou tradu\u00e7\u00e3o(\u00f5es) \u00e9 (s\u00e3o) nulo(s).");
        }
        if (locales.length != translations.length) {
            throw new IllegalArgumentException("Quantidade de idiomas \u00e9 diferente da quantidade de tradu\u00e7\u00f5es.");
        }
        for (int i = 0; i < locales.length; ++i) {
            this.set(locales[i], translations[i]);
        }
    }

    public boolean hasTranslation(Locale language) {
        return this.translations.containsKey(I18nUtil.convertLocaleToLanguageCode(language));
    }

    public List<Locale> getKeys() {
        ArrayList<Locale> result = new ArrayList<Locale>();
        for (String languageCode : this.translations.keySet()) {
            result.add(I18nUtil.convertLanguageCodeToLocale(languageCode));
        }
        return result;
    }

    public String get(int index) {
        if (this.translations.values().size() < index + 1) {
            return null;
        }
        return (String)this.translations.values().toArray()[index];
    }

    public String get(Locale locale) {
        String languageCode = I18nUtil.convertLocaleToLanguageCode(locale);
        if (this.translations.containsKey(languageCode)) {
            return this.translations.get(languageCode);
        }
        throw new TranslationNotFoundException("N\u00e3o existe tradu\u00e7\u00e3o para o c\u00f3digo do idioma " + languageCode + ".");
    }

    public void set(Locale locale, String translation) {
        String languageCode = I18nUtil.convertLocaleToLanguageCode(locale);
        if (languageCode.equals(this.preferredLanguageCode)) {
            this.preferredTranslation = translation;
            this.translations.put(languageCode, translation);
        } else {
            this.translations.put(languageCode, translation);
        }
    }

    public String get() {
        return this.preferredTranslation;
    }

    public void set(String translation) {
        if (this.hasApplicationMoreThenOneLanguages) {
            throw new InvalidOperationException("\u00c9 necess\u00e1rio informar o idioma da tradu\u00e7\u00e3o pois a aplica\u00e7\u00e3o suporta mais de um idioma.");
        }
        if (this.preferredLanguageCode == null || this.preferredLanguageCode.trim().equals("")) {
            this.preferredLanguageCode = PREFERRED_LANGUAGE_CODE;
        }
        this.translations.put(this.preferredLanguageCode, translation);
        this.preferredTranslation = translation;
    }

    public Map<String, String> getTranslations() {
        return this.translations;
    }

    public void setTranslations(Map<String, String> translations) {
        this.translations = new LinkedHashMap<String, String>(translations);
    }

    public int getCount() {
        return this.translations.size();
    }
}

