/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.command.management.basic.externaluser;

import br.com.petrobras.security.command.AbstractCommand;
import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.management.basic.IExternalUserManagerConsumer;
import br.com.petrobras.security.context.state.UserContextState;
import br.com.petrobras.security.exception.ExceptionHandler;
import br.com.petrobras.security.exception.ExceptionInfo;
import br.com.petrobras.security.exception.InvalidCredentialsException;

public class GenerateNewPasswordToExternalUserCommand
extends AbstractCommand<Boolean> {
    private IExternalUserManagerConsumer externalUserManagerConsumer;
    private String externalUserLoginArg;

    @Override
    protected void executeConsume() {
        if (super.getUserContextIdentifier().getCurrentUserContext().getState() == UserContextState.LOGGED) {
            MessageHeader mh = this.getMessageHeader();
            super.setReturnMessage(this.getExternalUserManagerConsumer().generateNewPassword(mh, this.getExternalUserLoginArg()));
        } else {
            super.setReturnMessage(this.getExternalUserManagerConsumer().generateNewPassword(null, this.getExternalUserLoginArg()));
        }
    }

    @Override
    protected void preExecute() {
        if (this.getUserContextIdentifier() == null) {
            throw new NullPointerException("UserContextIdentifier n\u00e3o est\u00e1 configurado.");
        }
    }

    @Override
    protected void posExecute() {
        if (super.getUserContextIdentifier().getCurrentUserContext().getState() == UserContextState.LOGGED) {
            this.getUserContextIdentifier().getCurrentUserContext().getTokenUser().setTicket(this.getReturnMessage().getNewTicket());
        }
        if (this.getReturnMessage().getExceptionInfo() != null) {
            try {
                ExceptionHandler.handle((ExceptionInfo)this.getReturnMessage().getExceptionInfo());
            }
            catch (InvalidCredentialsException ice) {
                if (super.getUserContextIdentifier().getCurrentUserContext().getState() == UserContextState.LOGGED) {
                    this.getUserContextIdentifier().getCurrentUserContext().logoff();
                }
                throw ice;
            }
        }
    }

    public IExternalUserManagerConsumer getExternalUserManagerConsumer() {
        return this.externalUserManagerConsumer;
    }

    public void setExternalUserManagerConsumer(IExternalUserManagerConsumer externalUserManagerConsumer) {
        this.externalUserManagerConsumer = externalUserManagerConsumer;
    }

    public String getExternalUserLoginArg() {
        return this.externalUserLoginArg;
    }

    public void setExternalUserLoginArg(String externalUserLoginArg) {
        this.externalUserLoginArg = externalUserLoginArg;
    }
}

