/*
 * UseCaseManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.configuration;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.configuration.IUseCaseManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.UseCase;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

public class UseCaseManagerConsumerSoapImpl implements IUseCaseManagerConsumer {

    /* [ Constantes ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 1381581452509772324L;
    
    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */

    public ReturnMessage<List<UseCase>> findAll(MessageHeader messageHeader) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllUseCases(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUseCaseListValue(
                srmwlvDTO, this.getUserContextIdentifier()
                        .getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

    }

    public ReturnMessage<UseCase> findById(MessageHeader messageHeader,
            String useCaseId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findUseCaseById(smhDTO, useCaseId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUseCaseValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    /*
     * public ReturnMessage<Boolean> save(MessageHeader messageHeader, UseCase
     * useCase) { // Converte o cabealho da mensagem em um cabealho de
     * mensagem SOAP. SoapMessageHeaderDTO smhDTO = MessageHeaderMounter
     * .mountTransferObject(messageHeader);
     *  // Converte o caso de uso local em um caso de uso de transferncia.
     * UseCaseDTO useCaseDTO = UseCaseMounter.mountTransferObject(useCase);
     *  // Executa o servio SOAP. ReturnMessageDTO rmDTO =
     * ConsumeSoapUtil.getCurrentEndPoint().saveUseCase(smhDTO, useCaseDTO);
     *  // Converte o retorno. return
     * ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO); }
     * 
     * public ReturnMessage<Boolean> update(MessageHeader messageHeader,
     * UseCase useCase) { // Converte o cabealho da mensagem em um cabealho de
     * mensagem SOAP. SoapMessageHeaderDTO smhDTO =
     * MessageHeaderMounter.mountTransferObject (messageHeader );
     *  // Converte o papel local em um papel de transferncia. UseCaseDTO
     * useCaseDTO = RoleMounter.mountTransferObject (role );
     *  // Montagem de objetos complexos. roleDTO.setType (
     * RoleTypeMounter.mountTransferObject (role.getType() ));
     * roleDTO.setApplicationEnvironment (
     * ApplicationEnvironmentMounter.mountTransferObject (
     * role.getApplicationEnvironment() )); roleDTO.setExpiration (
     * ExpirationMounter.mountTransferObject (role.getExpiration ()));
     *  // Executa o servio SOAP. ReturnMessageDTO rmDTO =
     * ConsumeSoapUtil.getCurrentEndPoint().updateRole (smhDTO, roleDTO );
     *  // Converte o retorno. return
     * ReturnMessageMounter.mountLocalObjectWithBooleanValue (rmDTO ); }
     * 
     * public ReturnMessage<Boolean> removeById(MessageHeader messageHeader,
     * String roleId) { // Converte o cabealho da mensagem em um cabealho de
     * mensagem SOAP. SoapMessageHeaderDTO smhDTO =
     * MessageHeaderMounter.mountTransferObject (messageHeader );
     *  // Executa o servio SOAP. ReturnMessageDTO rmDTO =
     * ConsumeSoapUtil.getCurrentEndPoint().removeRole (smhDTO, roleId );
     *  // Converte o retorno. return
     * ReturnMessageMounter.mountLocalObjectWithBooleanValue (rmDTO ); }
     */
    /* [ Operators ] */

}

