/*
 * DepartmentStatusMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.DepartmentStatus;
import br.com.petrobras.security.server.service.soap.DepartmentStatusDTO;

/**
 * Montador de estado de lotao.
 * 
 * @author Phelipe Perboires - JGTL
 * @since 1.0
 * @version 1.0
 * 
 */
public class DepartmentStatusMounter {

    /**
     * Monta um estado de lotao do modelo a partir de um estado de lotao de
     * transferncia.
     * 
     * @param statusDTO
     *            Estado de lotao de transferncia.
     * @return Estado de lotao do modelo.
     */
    public static DepartmentStatus mountModelObject(
            DepartmentStatusDTO statusDTO) {
        switch (statusDTO) {
        case ACTIVE:
            return DepartmentStatus.ACTIVE;
        case EXTINCT:
            return DepartmentStatus.EXTINCT;
        default:
            return DepartmentStatus.UNSUPPORTED;
        }
    }

    /**
     * Monta um estado de lotao de transferncia a partir de um estado de
     * lotao do modelo.
     * 
     * @param status
     *            Estado de lotao do modelo.
     * @return Estado de lotao de transferncia.
     */
    public static DepartmentStatusDTO mountTransferObject(
            DepartmentStatus status) {
        switch (status) {
        case ACTIVE:
            return DepartmentStatusDTO.ACTIVE;
        case EXTINCT:
            return DepartmentStatusDTO.EXTINCT;
        default:
            return DepartmentStatusDTO.UNSUPPORTED;
        }
    }

}

