/*
 * RegionalMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.Regional;
import br.com.petrobras.security.server.service.soap.RegionalDTO;

import javax.xml.datatype.DatatypeConfigurationException;

/**
 * Montador de regionais.
 * 
 * @author DMMD
 */
public class RegionalMounter {

    /**
     * Monta uma regional a partir de uma regional de transferncia.
     * 
     * @param regionalDTO
     *            Regional de transferncia.
     * @return regional.
     */
    public static Regional mountLocalObject(RegionalDTO regionalDTO)
    {
        if (regionalDTO == null)
        {
            return null;
        }
        else
        {
            Regional regional = new Regional();

            // Montagem simples.

            regional.setUid(regionalDTO.getUid());
            regional.setId(regionalDTO.getId());
            regional.setDescription(regionalDTO.getDescription());
            regional.setName(regionalDTO.getName());
            regional.setReadOnly(regionalDTO.isReadOnly());
            
            regional.setCreationDate(DateMounter.mountLocalObject(regionalDTO.getCreationDate()));
           
            return regional;
        }
    }
    
    /**
     * Monta uma regional de transferncia a partir de uma regional.
     * 
     * @param regional
     *            Regional.
     * @return regional de transferncia.
     */

    public static RegionalDTO mountTransferObject(Regional regional) {
        if (regional == null) {
            return null;
        } else {
            RegionalDTO regionalDTO = new RegionalDTO();

            // Montagem simples.
            regionalDTO.setUid(regional.getUid());
            regionalDTO.setId(regional.getId());
            regionalDTO.setDescription(regional.getDescription());
            regionalDTO.setName(regional.getName());
            regionalDTO.setReadOnly(regional.isReadOnly());
            
            
            try {
                regionalDTO.setCreationDate(DateMounter
                        .mountTransferObject(regional.getCreationDate()));
            } catch (DatatypeConfigurationException dtce) {
                throw new InvalidOperationException(
                        "No foi possvel converter a data de cadastro do caso de uso para enviar ao servio. "
                                + dtce.getMessage());
            }

            

            return regionalDTO;
        }
    }
    
}

