 /*
 * ResourceGroupMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.ResourceGroup;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.ResourceGroupDTO;

 import javax.xml.datatype.DatatypeConfigurationException;
 import java.util.List;
 import java.util.Locale;

/**
 * Montador de grupo de recursos.
 * 
 * @author Patrezze - YMPD
 * @since 3.0
 * @version 1.0
 *
 */
public class ResourceGroupMounter {

    /**
     * Monta um grupo de recursos de transferncia a partir de um grupo de
     * recursos do modelo.
     * 
     * @param resourceGroup
     *            Grupo de recursos.
     * @return Grupo de recursos de transferncia.
     */
    public static ResourceGroupDTO mountTransferObject(ResourceGroup resourceGroup) {
        
        ResourceGroupDTO resourceGroupDTO = new ResourceGroupDTO();
        resourceGroupDTO.setUid(resourceGroup.getUid());
        resourceGroupDTO.setId(resourceGroup.getId());
        resourceGroupDTO.setNameTranslations(I18nStringMounter.mountTransferObject(resourceGroup.getNameTranslations()));
        resourceGroupDTO.setDescriptionTranslations(I18nStringMounter.mountTransferObject(resourceGroup.getDescriptionTranslations()));
        resourceGroupDTO.setApplicationEnvironment(ApplicationEnvironmentMounter.mountTransferObject(resourceGroup.getApplicationEnvironment()));
        try {
            resourceGroupDTO.setCreationDate(DateMounter
                    .mountTransferObject(resourceGroup.getCreationDate()));
        } catch (DatatypeConfigurationException dce) {
            resourceGroupDTO.setCreationDate(null);
        }
        
        return resourceGroupDTO;
    }
        
    /**
     * Monta um grupo de recursos do modelo a partir de um grupo de recursos de transferncia.
     * 
     * @param resourceGroupDTO Grupo de recursos de transferncia.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idioma suportado pela aplicao.
     * @return Grupo de recursos do modelo.
     */
    public static ResourceGroup mountLocalObject(ResourceGroupDTO resourceGroupDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        ResourceGroup resourceGroup = new ResourceGroup();
        resourceGroup.setUid(resourceGroupDTO.getUid());
        resourceGroup.setId(resourceGroupDTO.getId());
        resourceGroup.setNameTranslations(I18nStringMounter.mountModelObject(resourceGroupDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
        resourceGroup.setDescriptionTranslations(I18nStringMounter.mountModelObject(resourceGroupDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));
        resourceGroup.setApplicationEnvironment(ApplicationEnvironmentMounter.mountLocalObject(resourceGroupDTO.getApplicationEnvironment(), preferredUserLanguage));
        resourceGroup.setCreationDate(DateMounter.mountLocalObject(resourceGroupDTO.getCreationDate()));

        return resourceGroup;
    }
    
}
