/*
 * RoleInformationValueAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.information.RoleInformationValueAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleInformationValueAuthorizationDTO;

import java.util.List;
import java.util.Locale;

public class RoleInformationValueAuthorizationMounter {

    public static RoleInformationValueAuthorization mountLocalObject(
            RoleInformationValueAuthorizationDTO roleInformationValueAuthorizationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        if (roleInformationValueAuthorizationDTO == null) { return null; }
        else {
            RoleInformationValueAuthorization roleInformationValueAuthorization = new RoleInformationValueAuthorization();

            roleInformationValueAuthorization.setUid(roleInformationValueAuthorizationDTO.getUid());

            roleInformationValueAuthorization.setRole(RoleMounter.mountLocalObject(roleInformationValueAuthorizationDTO.getRole(), 
                    preferredUserLanguage, supportedApplicationLanguages));
            roleInformationValueAuthorization.setInformationValue(InformationValueMounter
                    .mountLocalObject(roleInformationValueAuthorizationDTO.getInformationValue(),
                            preferredUserLanguage, supportedApplicationLanguages));


            return roleInformationValueAuthorization;
        }
    }

}
