/*
 * UserGroupMembershipMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.UserGroupMembership;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.UserGroupMembershipDTO;

import java.util.List;
import java.util.Locale;

public class UserGroupMembershipMounter {

    public static UserGroupMembership mountLocalObject (UserGroupMembershipDTO userGroupAuthorizationDTO ,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages)
    {
        if (userGroupAuthorizationDTO == null )
        {
            return null;
        }
        else 
        {
            UserGroupMembership userGroupAuthorization = new UserGroupMembership ();

            userGroupAuthorization.setUid(userGroupAuthorizationDTO.getUid());
            
            userGroupAuthorization.setCreationDate(DateMounter.mountLocalObject(userGroupAuthorizationDTO.getCreationDate()));
            
            userGroupAuthorization.setUserGroup(UserGroupMounter.mountLocalObject(userGroupAuthorizationDTO.getUserGroup(),preferredUserLanguage,supportedApplicationLanguages));
            userGroupAuthorization.setUser(UserMounter.mountModelObject(userGroupAuthorizationDTO.getUser()));
            
            return userGroupAuthorization;
        }            
    }
    
}
