/*
* @(#)UserListMounter.java
*
*/
/*
 * UserListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.User;
import br.com.petrobras.security.server.service.soap.UserDTO;

import java.util.ArrayList;
import java.util.List;

/**
 * Montador de lista de usurios.
 *
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 *
 */
public class UserListMounter {

    /**
     * Monta uma lista de usurios a partir de uma lista de usurios de transferncia.
     *
     * @param userDTOList Lista de usurios de transferncia.
     * @return Lista de usurios
     */
    public static List<User> mountModelObject(List<Object> userDTOList) {
        if (userDTOList == null ) { return null; }
        
        List<User> userList = new ArrayList<User>();

        for (Object objectUserDTO : userDTOList) {
            UserDTO userDTO = (UserDTO) objectUserDTO;
            userList.add(UserMounter.mountModelObject(userDTO));
        }
        return userList;
    }
}

