/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.annotation.aspectj;

import br.com.petrobras.security.ISecurityContext;
import br.com.petrobras.security.annotation.AuthorizedResource;
import br.com.petrobras.security.exception.PermissionDeniedException;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public class ResourceAuthorizedAnnotationInterpreter {
    private ISecurityContext securityContext = ISecurityContext.getContext();

    @Before(value="execution(* *(..)) && @annotation(authorizedResource)")
    public void verifyMethodAuthorization(AuthorizedResource authorizedResource) throws Throwable {
        this.verificaAutorizacaoCA(authorizedResource.value());
    }

    private void verificaAutorizacaoCA(String idRecurso) throws PermissionDeniedException {
        boolean isAuthorized = this.securityContext.getResourceAuthorizer().isAuthorized(idRecurso);
        if (!isAuthorized) {
            throw new PermissionDeniedException("Recurso " + idRecurso + "n\u00e3o est\u00e1 autorizado para o usu\u00e1rio corrente.");
        }
    }
}

