/*
 * Decompiled with CFR 0.152.
 */
package ControleAcesso;

import ControleAcesso.Main;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;

public class AutenticadorAD
implements Serializable {
    private static final long serialVersionUID = 1324526432760955985L;
    private static final String COMPLEMENTO_EMAIL_INTERNO = "@PETROBRAS.COM.BR";
    private Main controleAcesso;

    protected AutenticadorAD(Main objCA) {
        this.controleAcesso = objCA;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean validarCENPES(String chave, String senha) throws SecurityException, LDAPException, UnsupportedEncodingException, Exception {
        int ldapPort = 389;
        int searchScope = 2;
        int ldapVersion = 3;
        boolean attributeOnly = true;
        String[] attrs = new String[]{"1.1"};
        String ldapHost = "";
        String loginDN = this.controleAcesso.getApoio().getJavaLoginAD();
        String password = this.controleAcesso.getApoio().getSenhaLoginAD();
        LDAPConnection lc = new LDAPConnection();
        LDAPConnection lca = new LDAPConnection();
        String[] servidoresAD = this.controleAcesso.getApoio().getServidoresAD();
        int i = 0;
        while (i < servidoresAD.length) {
            ldapHost = servidoresAD[i];
            try {
                lc.connect(servidoresAD[i], ldapPort);
                break;
            }
            catch (LDAPException e) {
                if (i == servidoresAD.length) {
                    throw new SecurityException("Os Servidores LDAP configurados falharam.\n" + e.getMessage());
                }
                ++i;
            }
        }
        try {
            lca.connect(ldapHost, ldapPort);
            lc.bind(ldapVersion, loginDN, password.getBytes("UTF8"));
            i = 0;
            while (true) {
                if (i >= this.controleAcesso.getApoio().getDominiosAD().length) {
                    lc.disconnect();
                    lca.disconnect();
                    return false;
                }
                String dominio = this.controleAcesso.getApoio().getDominiosAD()[i];
                try {
                    lca.bind(ldapVersion, String.valueOf(chave) + "@" + dominio, senha.getBytes("UTF8"));
                    if (lca.getAuthenticationDN() != null) {
                        return true;
                    }
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new UnsupportedEncodingException("Erro no Encode da Password de Autentica\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo.\n" + uee.getMessage());
        }
    }

    protected boolean validar(String chave, String senha) throws Exception {
        if (chave == null || chave.trim().length() == 0 || senha == null || senha.trim().length() == 0) {
            return false;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", String.valueOf(chave.trim().toUpperCase()) + COMPLEMENTO_EMAIL_INTERNO);
        env.put("java.naming.security.credentials", senha);
        env.put("java.naming.provider.url", this.controleAcesso.getApoio().getUrlLDAP());
        try {
            new InitialLdapContext(env, null);
            return true;
        }
        catch (Exception e) {
            return this.autenticarUsuario(chave, senha);
        }
    }

    private DirContext getInicialLDAPContext() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.controleAcesso.getApoio().getJavaLoginAD());
        env.put("java.naming.security.credentials", this.controleAcesso.getApoio().getSenhaLoginAD());
        env.put("java.naming.provider.url", this.controleAcesso.getApoio().getUrlLDAP());
        env.put("java.naming.referral", "follow");
        try {
            return new InitialLdapContext(env, null);
        }
        catch (Exception e) {
            throw new Exception("Ocorreu um erro ao obter o acesso ao Active Directory.\r\n" + e.getMessage());
        }
    }

    private ArrayList getNomesPrincipaisDoUsuario(String login) throws Exception {
        login = login.trim().toUpperCase();
        String base = "dc=petrobras, dc=biz";
        String filter = "(&(objectClass=User) (sAMAccountName=" + login + "))";
        SearchControls controls = new SearchControls();
        String[] returnedAttributes = new String[]{"UserPrincipalName"};
        controls.setReturningAttributes(returnedAttributes);
        controls.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> answer = this.getInicialLDAPContext().search(base, filter, controls);
            ArrayList<String> emaisInternos = new ArrayList<String>();
            while (answer.hasMore()) {
                SearchResult searchResult = answer.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute eMailInterno = attributes.get("UserPrincipalName");
                emaisInternos.add(eMailInterno.toString().trim().toUpperCase());
            }
            return emaisInternos;
        }
        catch (Exception e) {
            throw new Exception("Login informado n\u00ef\u00bf\u00bdo foi encontrado.");
        }
    }

    public boolean autenticarUsuario(String login, String senha) throws Exception {
        Iterator iterator = this.getNomesPrincipaisDoUsuario(login).iterator();
        while (iterator.hasNext()) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", iterator.next().toString());
            env.put("java.naming.security.credentials", senha);
            env.put("java.naming.security.principal", this.controleAcesso.getApoio().getJavaLoginAD());
            env.put("java.naming.security.credentials", this.controleAcesso.getApoio().getSenhaLoginAD());
            env.put("java.naming.provider.url", this.controleAcesso.getApoio().getUrlLDAP());
            try {
                new InitialLdapContext(env, null);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String pegarDominio(String ChaveUsuario) throws Exception {
        String Dominio = null;
        String[] globalCat = new String[]{"DC=petrobras,DC=biz", "DC=refap,DC=biz", "DC=transp,DC=biz", "DC=ani,DC=petrobras,DC=biz", "DC=CENPES", "DC=EPBCNS20", "DC=GEARJ", "DC=juridico,DC=petrobras,DC=biz", "DC=LANSERING01", "DC=p-i,DC=ep,DC=petrobras,DC=biz", "DC=p-v,DC=ep,DC=petrobras,DC=biz", "DC=p-vi,DC=ep,DC=petrobras,DC=biz", "DC=ab,DC=petrobras,DC=biz", "DC=corp,DC=petrobras,DC=biz", "DC=ep,DC=petrobras,DC=biz", "DC=bc,DC=ep,DC=petrobras,DC=biz", "DC=bsol,DC=ep,DC=petrobras,DC=biz", "DC=es,DC=ep,DC=petrobras,DC=biz", "DC=rnce,DC=ep,DC=petrobras,DC=biz", "DC=seal,DC=ep,DC=petrobras,DC=biz", "DC=ge,DC=petrobras,DC=biz"};
        int i = 0;
        while (i < globalCat.length) {
            Dominio = null;
            String searchBase = globalCat[i];
            Hashtable<String, String> envDC = new Hashtable<String, String>();
            envDC.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            envDC.put("java.naming.security.authentication", "simple");
            envDC.put("java.naming.security.principal", "corp\\saadl");
            envDC.put("java.naming.security.credentials", "36bat89");
            envDC.put("java.naming.provider.url", "ldap://10.97.240.28/");
            envDC.put("java.naming.referral", "follow");
            envDC.put("java.naming.ldap.attributes.binary", "objectGUID objectSid msSFUPassword");
            InitialLdapContext ldapContext = new InitialLdapContext(envDC, null);
            SearchControls searchCtls = new SearchControls();
            String[] returnedAtts = new String[]{"distinguishedName", "userPrincipalName", "samAccountName"};
            searchCtls.setReturningAttributes(returnedAtts);
            searchCtls.setSearchScope(2);
            String searchFilter = "(&(objectClass=user)(objectCategory=person)(samAccountName=" + ChaveUsuario + "))";
            NamingEnumeration<SearchResult> answer = null;
            try {
                answer = ldapContext.search(searchBase, searchFilter, searchCtls);
                if (answer.hasMoreElements()) {
                    SearchResult sr = answer.next();
                    Attributes attrs = sr.getAttributes();
                    String distinguishedName = (String)attrs.get("distinguishedName").get();
                    Dominio = distinguishedName.toString();
                }
                if (Dominio != null) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        if (Dominio != null) {
            String[] vArrdistinguishedName = Dominio.split(",");
            String strDominio = null;
            int x = 0;
            while (x < vArrdistinguishedName.length) {
                if (vArrdistinguishedName[x].toString().indexOf("DC=") >= 0) {
                    strDominio = strDominio == null ? vArrdistinguishedName[x].toString() : String.valueOf(strDominio) + "." + vArrdistinguishedName[x].toString();
                    strDominio = strDominio.replaceAll("DC=", "");
                }
                ++x;
            }
            return strDominio;
        }
        return null;
    }
}

