/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.authorization;

import br.com.petrobras.security.authorization.IRoleAuthorizer;
import br.com.petrobras.security.command.authorization.access.FindAllRolesAdminAndAuthToUserCommand;
import br.com.petrobras.security.command.authorization.access.FindAllRolesAuthorizedToUserCommand;
import br.com.petrobras.security.command.authorization.access.VerifyEnterpriseGroupAuthorizationInRoleCommand;
import br.com.petrobras.security.command.authorization.access.VerifyRoleAuthorizationToUserCommand;
import br.com.petrobras.security.command.authorization.access.VerifyUserGroupAuthorizationInRoleCommand;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.Role;
import java.util.List;

public class RoleAuthorizerCoreImpl
implements IRoleAuthorizer {
    private static final long serialVersionUID = -5235970723194719589L;

    public List<Role> findAllAuthorizedAndAdministrated() throws PermissionDeniedException, InvalidOperationException, SecurityException {
        return this.findAllAuthorizedAndAdministrated(null, null);
    }

    public List<Role> findAllAuthorizedAndAdministrated(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.findAllAuthorizedAndAdministrated(userLogin, null);
    }

    public List<Role> findAllAuthorizedAndAdministrated(String userLogin, String areaId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllRolesAdminAndAuthToUserCommand cmd = ICommandIdentifier.getInstance().getFindAllRolesAdminAndAuthToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setTargetAreaIdArg(areaId);
        return (List)cmd.execute();
    }

    public boolean isAuthorizedToUserGroup(String userGroupId, String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.isAuthorizedToUserGroup(userGroupId, roleId, null);
    }

    public boolean isAuthorizedToUserGroup(String userGroupId, String roleId, String areaId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        VerifyUserGroupAuthorizationInRoleCommand cmd = ICommandIdentifier.getInstance().getVerifyUserGroupAuthorizationInRoleCommand();
        cmd.setUserGroupIdArg(userGroupId);
        cmd.setRoleIdArg(roleId);
        cmd.setTargetAreaIdArg(areaId);
        return (Boolean)cmd.execute();
    }

    public boolean isAuthorizedToEnterpriseGroup(String enterpriseGroupId, String roleId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        return this.isAuthorizedToEnterpriseGroup(enterpriseGroupId, roleId, null);
    }

    public boolean isAuthorizedToEnterpriseGroup(String enterpriseGroupId, String roleId, String areaId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        VerifyEnterpriseGroupAuthorizationInRoleCommand cmd = ICommandIdentifier.getInstance().getVerifyEnterpriseGroupAuthorizationInRoleCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.setRoleIdArg(roleId);
        cmd.setTargetAreaIdArg(areaId);
        return (Boolean)cmd.execute();
    }

    public boolean isAuthorizedToUser(String roleId) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        return this.isAuthorizedToUser(null, roleId, null);
    }

    public boolean isAuthorizedToUser(String userLogin, String roleId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        return this.isAuthorizedToUser(userLogin, roleId, null);
    }

    public boolean isAuthorizedToUser(String roleId, ContextValueSet contextValuesSet) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        return this.isAuthorizedToUser(null, roleId, contextValuesSet);
    }

    public boolean isAuthorizedToUser(String userLogin, String roleId, ContextValueSet contextValuesSet) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        VerifyRoleAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getVerifyRoleAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setRoleIdArg(roleId);
        cmd.setContextValueSetArg(contextValuesSet);
        if (contextValuesSet != null) {
            cmd.setConsiderContextArg(true);
        }
        return (Boolean)cmd.execute();
    }

    public List<Role> findAllAuthorized() throws PermissionDeniedException, InvalidOperationException, SecurityException {
        return this.findAllAuthorized(null, null);
    }

    public List<Role> findAllAuthorized(String userLogin) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        return this.findAllAuthorized(userLogin, null);
    }

    public List<Role> findAllAuthorized(ContextValueSet contextValuesSet) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        return this.findAllAuthorized(null, contextValuesSet);
    }

    public List<Role> findAllAuthorized(String userLogin, ContextValueSet contextValuesSet) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllRolesAuthorizedToUserCommand cmd = ICommandIdentifier.getInstance().getFindAllRolesAuthorizedToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setContextValueSetArg(contextValuesSet);
        if (null != contextValuesSet) {
            cmd.setConsiderContextArg(true);
        }
        return (List)cmd.execute();
    }
}

