/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.FindAllEnvAdmAuthorizationsByEnvironmentCommand;
import br.com.petrobras.security.command.management.authorization.FindEnvAdmAuthorizationByUserLoginCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IEnvironmentAdministrationAuthorizationManager;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.model.authorization.configuration.EnvironmentAdministrationAuthorization;
import java.util.List;

public class EnvironmentAdministrationAuthorizationManagerCoreImpl
implements IEnvironmentAdministrationAuthorizationManager {
    public EnvironmentAdministrationAuthorization find(String regionalId, String environmentId, String userLogin) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindEnvAdmAuthorizationByUserLoginCommand cmd = ICommandIdentifier.getInstance().getFindEnvAdmAuthorizationsByUserLoginCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setEnvironmentIdArg(environmentId);
        cmd.setUserLoginArg(userLogin);
        return (EnvironmentAdministrationAuthorization)cmd.execute();
    }

    public List<EnvironmentAdministrationAuthorization> findAll(Environment environment) throws PermissionDeniedException, InvalidArgumentException, SecurityException {
        return this.findAll(environment.getRegional().getId(), environment.getId());
    }

    public List<EnvironmentAdministrationAuthorization> findAll(String regionalId, String environmentId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllEnvAdmAuthorizationsByEnvironmentCommand cmd = ICommandIdentifier.getInstance().getFindAllEnvAdmAuthorizationsByEnvironmentCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setEnvironmentIdArg(environmentId);
        return (List)cmd.execute();
    }
}

