/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.informationsharing.FindAllApplicationsWithSharingAuthorizationInInformationCommand;
import br.com.petrobras.security.command.management.authorization.informationsharing.GrantInformationSharingAuthorizationToAppEnvCommand;
import br.com.petrobras.security.command.management.authorization.informationsharing.RevokeInformationSharingAuthorizationFromAppEnvCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IInformationSharingAuthorizationManager;
import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.Information;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class InformationSharingAuthorizationManagerCoreImpl
implements IInformationSharingAuthorizationManager {
    public void grant(ApplicationEnvironment applicationEnvironment, Information information) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)applicationEnvironment);
        Validator.throwInvalidArgumentExceptionIfNull((Object)applicationEnvironment.getApplication());
        Validator.throwInvalidArgumentExceptionIfNull((Object)applicationEnvironment.getEnvironment());
        Validator.throwInvalidArgumentExceptionIfNull((Object)applicationEnvironment.getEnvironment().getRegional());
        Validator.throwInvalidArgumentExceptionIfNull((Object)information);
        String regionalId = applicationEnvironment.getEnvironment().getRegional().getId();
        String applicationCatalogId = applicationEnvironment.getApplication().getCatalogId();
        this.grant(regionalId, applicationCatalogId, information.getId());
    }

    public void grant(String regionalId, String applicationCatalogId, String informationId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        GrantInformationSharingAuthorizationToAppEnvCommand cmd = ICommandIdentifier.getInstance().getGrantInformationSharingAuthorizationToAppEnvCommand();
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.execute();
    }

    public void revoke(ApplicationEnvironment applicationEnvironment, Information information) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)applicationEnvironment);
        Validator.throwInvalidArgumentExceptionIfNull((Object)applicationEnvironment.getApplication());
        Validator.throwInvalidArgumentExceptionIfNull((Object)applicationEnvironment.getEnvironment());
        Validator.throwInvalidArgumentExceptionIfNull((Object)applicationEnvironment.getEnvironment().getRegional());
        Validator.throwInvalidArgumentExceptionIfNull((Object)information);
        String regionalId = applicationEnvironment.getEnvironment().getRegional().getId();
        String applicationCatalogId = applicationEnvironment.getApplication().getCatalogId();
        this.revoke(regionalId, applicationCatalogId, information.getId());
    }

    public void revoke(String regionalId, String applicationCatalogId, String informationId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        RevokeInformationSharingAuthorizationFromAppEnvCommand cmd = ICommandIdentifier.getInstance().getRevokeInformationSharingAuthorizationFromAppEnvCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.execute();
    }

    public List<Application> findAllApplicationsWithSharingAuthorizationInInformation(String regionalId, String informationId) throws PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, InvalidArgumentException, SecurityException {
        FindAllApplicationsWithSharingAuthorizationInInformationCommand cmd = ICommandIdentifier.getInstance().getFindAllApplicationsWithSharingAuthorizationInInformationCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setInformationIdArg(informationId);
        return (List)cmd.execute();
    }
}

