/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.basic;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.basic.usergroupmembership.AddUserToGroupCommand;
import br.com.petrobras.security.command.management.basic.usergroupmembership.AddUsersListToGroupCommand;
import br.com.petrobras.security.command.management.basic.usergroupmembership.FindAllUserGroupMembershipsOfUserCommand;
import br.com.petrobras.security.command.management.basic.usergroupmembership.FindAllUserGroupMembershipsOfUserGroupIdCommand;
import br.com.petrobras.security.command.management.basic.usergroupmembership.RemoveUserFromGroupCommand;
import br.com.petrobras.security.command.management.basic.usergroupmembership.RemoveUsersListFromGroupCommand;
import br.com.petrobras.security.command.management.basic.usergroupmembership.VerifyUserGroupMembershipCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.basic.IUserGroupMembershipManager;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.model.UserGroup;
import br.com.petrobras.security.model.UserGroupMembership;
import br.com.petrobras.security.utility.Validator;
import java.util.ArrayList;
import java.util.List;

public class UserGroupMembershipManagerCoreImpl
implements IUserGroupMembershipManager {
    public List<UserGroupMembership> findAllInUserGroup(UserGroup userGroup) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        return this.findAllInUserGroup(userGroup.getId());
    }

    public List<UserGroupMembership> findAllInUserGroup(String userGroupId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllUserGroupMembershipsOfUserGroupIdCommand cmd = ICommandIdentifier.getInstance().getFindAllUserGroupMembershipsOfUserGroupIdCommand();
        cmd.setUserGroupIdArg(userGroupId);
        return (List)cmd.execute();
    }

    public List<UserGroupMembership> findCurrentUserGroups() throws PermissionDeniedException, SecurityException {
        FindAllUserGroupMembershipsOfUserCommand cmd = ICommandIdentifier.getInstance().getFindAllUserGroupMembershipsOfUserCommand();
        return (List)cmd.execute();
    }

    public List<UserGroupMembership> findUserGroups(User user) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        return this.findUserGroups(user.getLogin());
    }

    public List<UserGroupMembership> findUserGroups(String userLogin) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        FindAllUserGroupMembershipsOfUserCommand cmd = ICommandIdentifier.getInstance().getFindAllUserGroupMembershipsOfUserCommand();
        cmd.setUserLoginArg(userLogin);
        return (List)cmd.execute();
    }

    public void addUserToGroup(User user, UserGroup userGroup) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        this.addUserToGroup(user.getLogin(), userGroup.getId());
    }

    public void addUserToGroup(String userLogin, String userGroupId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        AddUserToGroupCommand cmd = ICommandIdentifier.getInstance().getAddUserToGroupCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setUserGroupIdArg(userGroupId);
        cmd.execute();
    }

    public void addUsersListToGroup(List<User> usersList, UserGroup userGroup) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull(usersList);
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        ArrayList<String> usersLogins = new ArrayList<String>();
        for (User user : usersList) {
            usersLogins.add(user.getLogin());
        }
        this.addUsersListToGroup(usersLogins, userGroup.getId());
    }

    public void addUsersListToGroup(List<String> usersLogins, String userGroupId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        AddUsersListToGroupCommand cmd = ICommandIdentifier.getInstance().getAddUsersListToGroupCommand();
        cmd.setUsersLoginsArg(usersLogins);
        cmd.setUserGroupIdArg(userGroupId);
        cmd.execute();
    }

    public void removeUserFromGroup(User user, UserGroup userGroup) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        this.removeUserFromGroup(user.getLogin(), userGroup.getId());
    }

    public void removeUserFromGroup(String userLogin, String userGroupId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        RemoveUserFromGroupCommand cmd = ICommandIdentifier.getInstance().getRemoveUserFromGroupCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setUserGroupIdArg(userGroupId);
        cmd.execute();
    }

    public void removeUsersListFromGroup(List<User> usersList, UserGroup userGroup) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull(usersList);
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        ArrayList<String> usersLogins = new ArrayList<String>();
        for (User user : usersList) {
            usersLogins.add(user.getLogin());
        }
        this.removeUsersListFromGroup(usersLogins, userGroup.getId());
    }

    public void removeUsersListFromGroup(List<String> usersLogins, String userGroupId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        RemoveUsersListFromGroupCommand cmd = ICommandIdentifier.getInstance().getRemoveUsersListFromGroupCommand();
        cmd.setUsersLoginsArg(usersLogins);
        cmd.setUserGroupIdArg(userGroupId);
        cmd.execute();
    }

    public boolean isMember(User user, UserGroup userGroup) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        return this.isMember(user.getLogin(), userGroup.getId());
    }

    public boolean isMember(String userLogin, String userGroupId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        VerifyUserGroupMembershipCommand cmd = ICommandIdentifier.getInstance().getVerifyUserGroupMembershipCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setUserGroupIdArg(userGroupId);
        return (Boolean)cmd.execute();
    }
}

