package br.com.petrobras.security.consume.soap.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.authorization.IAreaAuthorizerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Implementao SOAP do Consumidor de Autorizador de rea.
 *
 * @author Equipe de Desenvolvimento do Controle de Acesso Corporativo.
 * @version 4.3.0
 * @since 4.3.0
 */
public class AreaAuthorizerConsumerSoapImpl implements IAreaAuthorizerConsumer {

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -5714138356230023684L;

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     *
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     *
     * @param userContextIdentifier Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* (non-Javadoc)
      * @see br.com.petrobras.security.consume.authorization.IAreaAuthorizerConsumer#findAllAuthorizedToUser(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
      */
    @Override
    public ReturnMessage<List<Area>> findAllAuthorizedToUser(MessageHeader messageHeader, String userLogin) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllAreasAuthorizedToUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithAreaListValue(
                rmDTO,
                getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    @Override
    public ReturnMessage<List<Area>> findAllWhereResourceIsAuthorized(MessageHeader messageHeader, String userLogin, String resourceId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllAreasWhereResourceIsAuthorized(smhDTO, userLogin, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithAreaListValue(
                rmDTO,
                getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

}
