 /*
 * ResourceGroupMembershipManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.access;

 import br.com.petrobras.security.consume.MessageHeader;
 import br.com.petrobras.security.consume.ReturnMessage;
 import br.com.petrobras.security.consume.management.access.IResourceGroupMembershipManagerConsumer;
 import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
 import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
 import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
 import br.com.petrobras.security.context.identification.IUserContextIdentifier;
 import br.com.petrobras.security.model.ResourceGroupMembership;
 import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

 import java.util.List;

/**
 * Implementao "SOAP" do consumidor de gerenciamento de membros de grupo de
 * recursos.
 * 
 * @author Patrezze - YMPD
 * @since 3.0
 * @version 1.0
 * 
 */
public class ResourceGroupMembershipManagerConsumerSoapImpl implements
        IResourceGroupMembershipManagerConsumer {

    /* [ Dependences ] */
    
    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }
    
    /* [ Dependences ] */
    
    /* [ Caso de Uso "Adiciona o recurso ao grupo de recursos" ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.access.IResourceGroupMembershipManagerConsumer#addResourceToGroup(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> addResourceToGroup(
            MessageHeader messageHeader, String resourceGroupId,
            String resourceId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .addResourceToGroup(smhDTO, resourceGroupId, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Caso de Uso "Adiciona o recurso ao grupo de recursos" ] */
    
    /* [ Caso de Uso "Consulta os membros do grupo de recursos" ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.access.IResourceGroupMembershipManagerConsumer#findAllResourceGroupMembershipInGroupById(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<List<ResourceGroupMembership>> findAllResourceGroupMembershipInGroupById(
            MessageHeader messageHeader, String resourceGroupId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllResourceGroupMembershipInGroup(smhDTO, resourceGroupId);
        
        return ReturnMessageMounter
                .mountLocalObjectWithResourceGroupMembershipListValue(rmDTO,
                        this.getUserContextIdentifier().getCurrentUserContext()
                                .getPreferredUserLanguage(), this
                                .getUserContextIdentifier()
                                .getCurrentUserContext()
                                .getSupportedApplicationLanguages());
    }
    
    /* [ Caso de Uso "Consulta os membros do grupo de recursos" ] */

    /* [ Caso de Uso "Verifica se o recurso  membro grupo de recursos" ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.access.IResourceGroupMembershipManagerConsumer#isMember(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> isMember(MessageHeader messageHeader,
            String resourceGroupId, String resourceId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .isResourceGroupMembership(smhDTO, resourceGroupId, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Caso de Uso "Verifica se o recurso  membro grupo de recursos" ] */
    
    /* [ Caso de Uso "Remove o recurso do grupo de recursos" ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.access.IResourceGroupMembershipManagerConsumer#removeResourceFromGroup(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> removeResourceFromGroup(
            MessageHeader messageHeader, String resourceGroupId,
            String resourceId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .removeResourceFromGroup(smhDTO, resourceGroupId, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }
    
    /* [ Caso de Uso "Remove o recurso do grupo de recursos" ] */

}
