/*
 * RoleManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.access;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.access.IRoleManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.*;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.RoleType;
import br.com.petrobras.security.server.service.soap.RoleDTO;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Implementao "SOAP" do consumidor de gerenciador de papel.
 * 
 * @author Equipe de desenvolvimento do Sistema de Controle de Acesso
 *         Corporativo.
 * 
 */
public class RoleManagerConsumerSoapImpl implements IRoleManagerConsumer {
 
    /* [ Constantes ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -1158107754813648614L;
    
    /* [ Constantes ] */
    
    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */

    /* [ Caso de Uso "Incluir Papel" ] */

    public ReturnMessage<Boolean> save(MessageHeader messageHeader, Role role) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte o papel local em um papel de transferncia.
        RoleDTO roleDTO = RoleMounter.mountTransferObject(role, this
                .getUserContextIdentifier().getCurrentUserContext()
                .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .saveRole(smhDTO, roleDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Caso de Uso "Incluir Papel" ] */

    /* [ Caso de Uso "Alterar Papel" ] */

    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            String oldRoleId, Role newRoleToUpdate) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte o papel local em um papel de transferncia.
        RoleDTO roleDTO = RoleMounter.mountTransferObject(newRoleToUpdate, this
                .getUserContextIdentifier().getCurrentUserContext()
                .getSupportedApplicationLanguages());

        // Montagem de objetos complexos.
        roleDTO.setType(RoleTypeMounter.mountTransferObject(newRoleToUpdate
                .getType()));
        roleDTO.setExpiration(ExpirationMounter
                .mountTransferObject(newRoleToUpdate.getExpiration()));

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .updateRole(smhDTO, oldRoleId, roleDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    public ReturnMessage<Boolean> update(MessageHeader messageHeader, Role roleWithUidLoadToUpdate) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Converte o papel local em um papel de transferncia.
        RoleDTO roleDTO = RoleMounter.mountTransferObject(
                roleWithUidLoadToUpdate,
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        // Montagem de objetos complexos.
        roleDTO.setType(RoleTypeMounter.mountTransferObject(roleWithUidLoadToUpdate.getType()));
        roleDTO.setExpiration(ExpirationMounter.mountTransferObject(roleWithUidLoadToUpdate.getExpiration()));

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().updateRoleWithUidLoaded(smhDTO, roleDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Caso de Uso "Alterar Papel" ] */

    /* [ Caso de Uso "Excluir Papel" ] */

    public ReturnMessage<Boolean> removeById(MessageHeader messageHeader, String roleId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().removeRoleById(smhDTO, roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Caso de Uso "Excluir Papel" ] */

    /* [ Caso de Uso "Consultar Papel" ] */

    public ReturnMessage<Role> findById(MessageHeader messageHeader, String roleId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findRoleById(smhDTO, roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleValue(
                rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    public ReturnMessage<List<Role>> findAll(MessageHeader messageHeader) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllRoles(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleListValue(
                srmwlvDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    public ReturnMessage<List<Role>> findByIds(MessageHeader messageHeader, List<String> roleIds) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findRolesById(smhDTO, roleIds);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleListValue(
                srmwlvDTO, this.getUserContextIdentifier()
                        .getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.access.IRoleManagerConsumer#findAllTypes(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<RoleType>> findAllTypes(
            MessageHeader messageHeader) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllRoleTypes(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleTypeListValue(
                srmwlvDTO, this.getUserContextIdentifier()
                        .getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    /* [ Caso de Uso "Consultar Papel" ] */

    /* [ Operators ] */

}

