/*
 * ApplicationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.basic;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.basic.IApplicationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

public class ApplicationManagerConsumerSoapImpl implements IApplicationManagerConsumer {
 
    /* [ Constantes ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 7108890222566287956L;

    /* [ Constantes ] */
    
    /* [ Dependences ] */
    
    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */    
    
    
    public ReturnMessage<List<Application>> findAll(MessageHeader messageHeader) {
         // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject (messageHeader );

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllApplications(smhDTO);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithApplicationListValue(srmwlvDTO,this
                .getUserContextIdentifier().getCurrentUserContext()
                .getPreferredUserLanguage());
    }

    public ReturnMessage<Application> findById(MessageHeader messageHeader,
            String catalogId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findApplicationByCatalogId(smhDTO, catalogId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithApplicationValue(rmDTO,this
                .getUserContextIdentifier().getCurrentUserContext()
                .getPreferredUserLanguage());
    }

    public ReturnMessage<List<Application>> findAllInEnvironment(
            MessageHeader messageHeader, String regionalId, String environmentId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject (messageHeader );

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = 
            ConsumeSoapUtil.getCurrentEndPoint().findAllApplicationsInEnvironment(smhDTO, regionalId, environmentId);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithApplicationListValue(srmwlvDTO,this
                .getUserContextIdentifier().getCurrentUserContext()
                .getPreferredUserLanguage());
    }

}

