 /*
 * CompanyManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.enterprise;

 import br.com.petrobras.security.consume.MessageHeader;
 import br.com.petrobras.security.consume.ReturnMessage;
 import br.com.petrobras.security.consume.management.enterprise.ICompanyManagerConsumer;
 import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
 import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
 import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
 import br.com.petrobras.security.model.Company;
 import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

 import java.util.List;

/**
 * Implementao "SOAP" do consumidor de gerenciador de empresa.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class CompanyManagerConsumerSoapImpl implements ICompanyManagerConsumer {

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.ICompanyManagerConsumer#find(br.com.petrobras.security.consume.MessageHeader, java.lang.Long)
     */
    public ReturnMessage<Company> find(MessageHeader messageHeader,
            Long companyCode) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findCompanyByCode(smhDTO, companyCode);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithCompanyValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.ICompanyManagerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<Company>> findAll(MessageHeader messageHeader) {

        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllCompanies(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithCompanyListValue(rmDTO);
    }

}
