/*
* @(#)ApplicationEnvironmentListMounter.java
*
*/
/*
 * ApplicationEnvironmentListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.server.service.soap.ApplicationEnvironmentDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Montador de lista de ambientes de aplicao.
 *
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 *
 */
public class ApplicationEnvironmentListMounter {

    /**
     * Monta uma lista de ambientes de aplicao a partir de uma lista de
     * transferncia.
     * 
     * @param applicationEnvironmentListDTO
     *            Lista de transferncia.
     * @return Lista de ambientes de aplicao.
     */
    public static List<ApplicationEnvironment> mountLocalObjectList(List<Object> applicationEnvironmentListDTO, Locale preferredUserLanguage) {
        if (applicationEnvironmentListDTO == null ) { return null; }
        else {
            List<ApplicationEnvironment> applicationEnvironmentList = new ArrayList<ApplicationEnvironment> ();

            for (Object objectDTO : applicationEnvironmentListDTO) {
                ApplicationEnvironmentDTO applicationEnvironmentDTO = (ApplicationEnvironmentDTO)objectDTO;
                applicationEnvironmentList.add(ApplicationEnvironmentMounter.mountLocalObject(applicationEnvironmentDTO, preferredUserLanguage));
            }
            
            return applicationEnvironmentList;
        }
    }
}

