/*
 * ContractedWorkerUserMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.ContractedWorkerUser;
import br.com.petrobras.security.server.service.soap.ContractedWorkerUserDTO;

/**
 * @author Rodrigo Carvalho - UPM7
 * 
 */
public class ContractedWorkerUserMounter {

    public static ContractedWorkerUser mountModelObject(
            ContractedWorkerUserDTO contractedDTO) {
        if (contractedDTO == null) {
            return null;
        }

        ContractedWorkerUser contracted = new ContractedWorkerUser();
        mountModelObject(contractedDTO, contracted);

        return contracted;
    }

    static void mountModelObject(ContractedWorkerUserDTO contractedDTO,
            ContractedWorkerUser contracted) {
        UserMounter.mountModelObject(contractedDTO, contracted);

        contracted.setSapId(contractedDTO.getSapId());
        contracted.setDepartment(DepartmentMounter
                .mountLocalObject(contractedDTO.getDepartment()));
    }

    public static ContractedWorkerUserDTO mountTransferObject(
            ContractedWorkerUser contracted) {
        if (contracted == null) {
            return null;
        }

        ContractedWorkerUserDTO contractedDTO = new ContractedWorkerUserDTO();
        mountTransferObject(contracted, contractedDTO);

        return contractedDTO;
    }

    static void mountTransferObject(ContractedWorkerUser contracted,
            ContractedWorkerUserDTO contractedDTO) {
        UserMounter.mountTransferObject(contracted, contractedDTO);
        
        contractedDTO.setSapId(contracted.getSapId());
        contractedDTO.setDepartment(DepartmentMounter
                .mountTransferObject(contracted.getDepartment()));
    }
}
