/*
 * EmployeeUserMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.EmployeeUser;
import br.com.petrobras.security.server.service.soap.EmployeeUserDTO;

/**
 * @author Rodrigo Carvalho - UPM7
 * 
 */
public class EmployeeUserMounter {

    public static EmployeeUser mountModelObject(EmployeeUserDTO employeeDTO) {
        if (employeeDTO == null) {
            return null;
        }

        EmployeeUser employee = new EmployeeUser();
        mountModelObject(employeeDTO, employee);

        return employee;
    }

    static void mountModelObject(EmployeeUserDTO employeeDTO,
            EmployeeUser employee) {
        UserMounter.mountModelObject(employeeDTO, employee);

        employee.setRegistration(employeeDTO.getRegistrationNumber());
        employee.setDepartment(DepartmentMounter
                .mountLocalObject(employeeDTO.getDepartment()));
        employee.setOccupation(OccupationMounter.mountLocalObject(employeeDTO
                .getOccupation()));
        employee.setFunction(FunctionMounter.mountLocalObject(employeeDTO
                .getFunction()));
    }

    public static EmployeeUserDTO mountTransferObject(EmployeeUser employee) {
        if (employee == null) {
            return null;
        }

        EmployeeUserDTO employeeDTO = new EmployeeUserDTO();
        mountTransferObject(employee, employeeDTO);

        return employeeDTO;
    }

    static void mountTransferObject(EmployeeUser employee,
            EmployeeUserDTO employeeDTO) {
        UserMounter.mountTransferObject(employee, employeeDTO);
        employeeDTO.setRegistrationNumber(employee.getRegistration());
        employeeDTO.setDepartment(DepartmentMounter
                .mountTransferObject(employee.getDepartment()));
        employeeDTO.setOccupation(OccupationMounter
                .mountTransferObject(employee.getOccupation()));
        employeeDTO.setFunction(FunctionMounter.mountTransferObject(employee
                .getFunction()));
    }
}
