/*
 * LocaleMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.Locale;
import br.com.petrobras.security.server.service.soap.LocaleDTO;
import br.com.petrobras.security.utility.Validator;

public class LocaleMounter {
    public static Locale mountModelObject(LocaleDTO localeDTO) {
        if (localeDTO != null) {
            Locale locale = new Locale();

            locale.setUid(localeDTO.getUid());
            locale.setLanguageCode(localeDTO.getLanguageCode());

            return locale;
        } else {
            return null;
        }
    }

    public static java.util.Locale convertToUtilLocale(Locale locale) {
        if (locale != null) {
            
            String languageCode = locale.getLanguageCode();
            
            if (languageCode != null) {                
                String[] languageCodeSplit = languageCode.split("_");
                
                if (languageCodeSplit.length > 0) {
                
                    if (languageCodeSplit.length == 1) {
                        String language = languageCodeSplit[0];
                        
                        return new java.util.Locale(language);
                    } else {
                        String language = languageCodeSplit[0];
                        String country = languageCodeSplit[1];
                        
                        return new java.util.Locale(language, country);
                    }    
                    
                } else {
                    return null;
                }
            }
            else {
                return null;
            }
            
        } else {
            return null;
        }
    }
    
    public static LocaleDTO mountTransferObject(Locale locale) {
        if (locale != null) {
            LocaleDTO localeDTO = new LocaleDTO();

            localeDTO.setUid(locale.getUid());
            localeDTO.setLanguageCode(locale.getLanguageCode());

            return localeDTO;
        } else {
            return null;
        }
    }
    
    public static Locale convertToLocale(java.util.Locale localeUtil) {
        if (localeUtil == null ) { return null; }
        
        Locale locale = new Locale();
        String languageCode = "";
        
        if (!Validator.isNullOrEmpty(localeUtil.getLanguage())) {
            
            languageCode += localeUtil.getLanguage();
            
            if (!Validator.isNullOrEmpty(localeUtil.getCountry())) {
                languageCode += "_" + localeUtil.getCountry();                    
            }
        }
        else {
            return null;
        }   
        
        locale.setLanguageCode(languageCode);
        return locale;
    }

    public static void updateLocalObject(LocaleDTO localeDTO, Locale locale) {
        if (locale != null && localeDTO != null) {
            if (locale.getUid().equals(localeDTO.getUid()) == false) {
                throw new InvalidOperationException(
                        "Identificador do idioma  diferente da identificador do idioma de transferncia.");
            }

            locale.setUid(localeDTO.getUid());
            locale.setLanguageCode(localeDTO.getLanguageCode());
        }
    }
}

