/*
 * NotificationRegistrationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.util.NotificationRegistration;
import br.com.petrobras.security.server.service.soap.NotificationRegistrationDTO;

/**
 * @author Rodrigo Carvalho - UPM7
 * 
 */
public class NotificationRegistrationMounter {

    public static NotificationRegistration mountModelObject(
            NotificationRegistrationDTO notificationRegistrationDTO) {
        
        if (notificationRegistrationDTO == null) { return null; }

        NotificationRegistration notificationRegistration = new NotificationRegistration();

        notificationRegistration.setNotificationUrl(notificationRegistrationDTO.getNotificationUrl());

        notificationRegistration.setUseCaseIds(notificationRegistrationDTO.getUseCaseIds());

        return notificationRegistration;
    }

    public static NotificationRegistrationDTO mountTransferObject(
            NotificationRegistration notificationRegistration) {
        
        if (notificationRegistration == null) { return null; }

        NotificationRegistrationDTO notificationRegistrationDTO = new NotificationRegistrationDTO();

        notificationRegistrationDTO.setNotificationUrl(notificationRegistration.getNotificationUrl());

        notificationRegistrationDTO.getUseCaseIds().addAll(notificationRegistration.getUseCaseIds());

        return notificationRegistrationDTO;
    }
}
