/*
* @(#)ResourceTypeListMounter.java
*
*/
/*
 * ResourceTypeListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.ResourceType;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.ResourceTypeDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Montador de lista de recursos de papel.
 *
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 *
 */
public class ResourceTypeListMounter {

    /**
     * Monta uma lista de tipos de recursos a partir de uma lista de
     * transferncia.
     * 
     * @param resourceTypeListDTO
     *            Lista de transferncia.
     * @return Lista de tipos de papel.
     */
    public static List<ResourceType> mountLocalObjectList (List<Object> resourceTypeListDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages  )
    {
        if (resourceTypeListDTO == null ) { return null; }
        else
        {
            List<ResourceType> resourceTypeList = new ArrayList<ResourceType> ();
    
            for (Object objectDTO : resourceTypeListDTO) {
                ResourceTypeDTO resourceTypeDTO = (ResourceTypeDTO)objectDTO;
                resourceTypeList.add(ResourceTypeMounter.mountLocalObject(resourceTypeDTO, preferredUserLanguage, supportedApplicationLanguages));
            }
            
            return resourceTypeList;
        }
    }  
}

