/*
 * ResourceTypeMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.ResourceType;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.ResourceTypeDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.List;
import java.util.Locale;

/**
 * Montador de tipo de recurso
 * @author Equipe de Desenvolvimento do Contresource de Acesso Corporativo
 *
 */
public class ResourceTypeMounter {

    public static ResourceType mountLocalObject
        (ResourceTypeDTO resourceTypeDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages )
    {
        if (resourceTypeDTO == null )
        {
            return null;
        }
        else
        {
            ResourceType resourceType = new ResourceType ();

            // Montagem simples.
            resourceType.setUid (resourceTypeDTO.getUid());
            resourceType.setId(resourceTypeDTO.getId());
            resourceType.setCreationDate(DateMounter.mountLocalObject(resourceTypeDTO.getCreationDate()));
            
            // Montagem da I18n.
            resourceType.setNameTranslations (I18nStringMounter.mountModelObject(resourceTypeDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            return resourceType;
        }
    }

    public static ResourceTypeDTO mountTransferObject
        (ResourceType resourceType, List<SupportedLanguage> supportedLanguages )
    {
        if (resourceType == null )
        {
            return null;
        }
        else
        {
            ResourceTypeDTO resourceTypeDTO = mountTransferObject(resourceType);
            
            // Montagem da I18n.
            resourceTypeDTO.setNameTranslations(I18nStringMounter.mountTransferObject(resourceType.getNameTranslations(), supportedLanguages));
            
            return resourceTypeDTO;
        }
    }
    

    public static ResourceTypeDTO mountTransferObject(ResourceType resourceType) {
         if (resourceType == null )
         {
             return null;
         }
         else
         {
             ResourceTypeDTO resourceTypeDTO =
                 new ResourceTypeDTO ();

             // Montamge simples.
             resourceTypeDTO.setUid(resourceType.getUid());
             resourceTypeDTO.setId(resourceType.getId());
             
             try {
                 resourceTypeDTO.setCreationDate(DateMounter.mountTransferObject(resourceType.getCreationDate()));
             }
             catch(DatatypeConfigurationException dtce) {
                 throw new InvalidOperationException(
                         "No foi possvel converter a data de cadastro do tipo de recurso para enviar ao servio. "
                                 + dtce.getMessage());
             }

             return resourceTypeDTO;
         }
    }
}

