package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.UserGroup;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.UserGroupDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class UserGroupListMounter {

    public static List<UserGroup> mountLocalObject(
            List<Object> userGroupListDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (userGroupListDTO == null) {
            return null;
        } else {
            List<UserGroup> userGroupList = new ArrayList<UserGroup>();

            for (Object objectUserGroupDTO : userGroupListDTO) {
                UserGroupDTO userGroupDTO = (UserGroupDTO) objectUserGroupDTO;
                userGroupList.add(UserGroupMounter.mountLocalObject(
                        userGroupDTO, preferredUserLanguage,
                        supportedApplicationLanguages));
            }

            return userGroupList;
        }
    }

}
