
package br.com.petrobras.security.server.service.soap;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for UserTypeDTO.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="UserTypeDTO">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="EMPLOYEE"/>
 *     &lt;enumeration value="CONTRACTED_WORKER"/>
 *     &lt;enumeration value="EXTERNAL"/>
 *     &lt;enumeration value="UNSUPPORTED"/>
 *     &lt;enumeration value="B2B"/>
 *     &lt;enumeration value="B2C"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "UserTypeDTO")
@XmlEnum
public enum UserTypeDTO {

    EMPLOYEE("EMPLOYEE"),
    CONTRACTED_WORKER("CONTRACTED_WORKER"),
    EXTERNAL("EXTERNAL"),
    UNSUPPORTED("UNSUPPORTED"),
    @XmlEnumValue("B2B")
    B_2_B("B2B"),
    @XmlEnumValue("B2C")
    B_2_C("B2C");
    private final String value;

    UserTypeDTO(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static UserTypeDTO fromValue(String v) {
        for (UserTypeDTO c: UserTypeDTO.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
