/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.EnumerationColumn;
import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TextColumn;
import csbase.rest.adapter.algorithm.v1.ParameterFactory;
import ibase.rest.model.algorithm.v2.ColumnOfElements;
import ibase.rest.model.algorithm.v2.ColumnType;
import ibase.rest.model.algorithm.v2.EnumerationItem;
import ibase.rest.model.algorithm.v2.Parameter;
import ibase.rest.model.algorithm.v2.ParameterType;
import ibase.rest.model.algorithm.v2.TableParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TableParameterFactory
implements ParameterFactory {
    @Override
    public Parameter buildParameter(SimpleParameter<?> p) {
        csbase.logic.algorithms.parameters.TableParameter csbaseParam = (csbase.logic.algorithms.parameters.TableParameter)p;
        TableParameter parameter = new TableParameter();
        this.setCommonAttributes((Parameter)parameter, (SimpleParameter<?>)csbaseParam);
        parameter.setType(this.getType());
        List columns = csbaseParam.getColumns();
        ArrayList columnOfElements = new ArrayList();
        columns.forEach(c -> columnOfElements.add(this.makeColumn((TableColumn<?>)c)));
        parameter.setItems(columnOfElements);
        return parameter;
    }

    private EnumerationItem buildEnumItem(csbase.logic.algorithms.parameters.EnumerationItem i) {
        EnumerationItem item = new EnumerationItem();
        item.setId(i.getId());
        item.setLabel(i.getLabel());
        item.setValue(i.getValue());
        return item;
    }

    private ColumnOfElements makeColumn(TableColumn<?> c) {
        ColumnOfElements column = new ColumnOfElements();
        String type = null;
        if (c instanceof BooleanColumn) {
            type = ColumnType.BOOLEAN.toString();
        } else if (c instanceof DoubleColumn) {
            type = ColumnType.DOUBLE.toString();
        } else if (c instanceof TextColumn) {
            type = ColumnType.STRING.toString();
        } else if (c instanceof IntegerColumn) {
            type = ColumnType.INTEGER.toString();
        } else if (c instanceof EnumerationColumn) {
            type = ColumnType.ENUMERATION.toString();
            column.setEnumerationItems(((EnumerationColumn)c).getItems().stream().map(this::buildEnumItem).collect(Collectors.toList()));
        }
        if (type == null) {
            column.setElementType(ColumnType.UNSUPPORTED.toString());
        } else {
            column.setElementType(type);
        }
        column.setDefaultValue(c.getDefaultValue());
        column.setId(c.getId());
        column.setHeader(c.getLabel());
        return column;
    }

    @Override
    public String getType() {
        return ParameterType.TABLE.toString();
    }
}

