package csbase.rest.adapter.application.v1;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

import csbase.logic.RemoteFileInputStream;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ApplicationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import ibase.rest.api.application.v1.adapter.ApplicationServiceAdapter;
import ibase.rest.model.application.v1.Application;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

/**
 * Created by mjulia on 08/06/16.
 */
public class CSBaseApplicationServiceAdapter implements
  ApplicationServiceAdapter {

  private final static String CURRENT_SYSTEM_ID = ".";

  private static final Logger logger = Logger.getLogger(
    CSBaseApplicationServiceAdapter.class.getName());

  @Override
  public void setLocale(Locale locale) {
    ClientRemoteLocator.administrationService.setLocale(locale);
  }

  @Override
  public Optional<Application> getApplication(String appId) {
    ApplicationServiceInterface service =
      ClientRemoteLocator.applicationService;

    try {
      ApplicationRegistry appReg = service.getApplicationRegistry(appId);
      Optional<Application> application = Optional.empty();
      application = Optional.of(buildApplication(appReg));
      return application;
    }
    catch (Exception e) {
      logger.log(Level.SEVERE, "Erro no metodo getApplication", e);
      return null;
    }
  }

  @Override
  public List<Application> getApplications(Predicate<Application> predicate) {
    ApplicationServiceInterface service =
      ClientRemoteLocator.applicationService;

    try {
      Hashtable<String, ApplicationRegistry> appRegistries;
      appRegistries = service.getApplicationRegistries();

      Collection<ApplicationRegistry> appRegValues = appRegistries.values();
      List<Application> applications = new ArrayList<Application>();

      Iterator<ApplicationRegistry> iterator = appRegValues.iterator();

      while (iterator.hasNext()) {
        ApplicationRegistry next = iterator.next();
        Application a = buildApplication(next);
        if (predicate == null) {
          applications.add(a);
        }
        else if (predicate.test(a)) {
          applications.add(a);
        }
      }
      applications.sort(new Comparator<Application>() {

        @Override public int compare(Application o1, Application o2) {
          return o1.getName().compareTo(o2.getName());
        }
      });
      return applications;
    }
    catch (Exception e) {
      logger.log(Level.SEVERE, "Erro no metodo getApplications", e);
      return null;
    }
  }

  @Override
  public InputStream getApplicationDocFileStream(String appId, String fileName) {
    try {
      ApplicationServiceInterface service =
        ClientRemoteLocator.applicationService;
      final String[] resourcePath = new String[] { "html", fileName };
      RemoteFileChannelInfo appResource = service.getApplicationResource(appId, resourcePath);
      if (appResource == null) {
        return null;
      }
      return new RemoteFileInputStream(appResource);
    }
    catch (Exception e) {
      logger.log(Level.SEVERE, "Erro no metodo getApplicationDocFileStream", e);
      return null;
    }
  }

  @Override
  public String getApplicationLatestVersion(List<String> versionIds) {
    if (versionIds == null || (versionIds != null && versionIds.size() == 0)) {
      return null;
    }
    if (versionIds.size() == 1) {
      return versionIds.get(0);
    }
    Collections.sort(versionIds, Collections.reverseOrder());
    return versionIds.get(0);
  }

  /**
   * Build a JSON application object model.
   *
   * @param appReg The CSBase application info
   * @return the JSON object representing the application
   */
  private static Application buildApplication(ApplicationRegistry appReg) {
    Application application = new Application();
    application.setName(appReg.getClassName());
    application.setId(appReg.getId());
    application.setAuthor(appReg.getAuthorName());
    application.setVersion(appReg.getVersion());
    return application;
  }
}