package Requests.Projects;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TeamMember   {
    private String id = null;

    private String login = null;

    private String name = null;

    private List<String> roles = new ArrayList<String>();

    private String avatar = null;

    private Boolean editable = null;

    public TeamMember id(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TeamMember login(String login) {
        this.login = login;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public TeamMember name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TeamMember roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public TeamMember addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    public List<String> getRoles() {
        return roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public TeamMember avatar(String avatar) {
        this.avatar = avatar;
        return this;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public TeamMember editable(Boolean editable) {
        this.editable = editable;
        return this;
    }

    public Boolean getEditable() {
        return editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TeamMember teamMember = (TeamMember) o;
        return Objects.equals(this.id, teamMember.id) &&
                Objects.equals(this.login, teamMember.login) &&
                Objects.equals(this.name, teamMember.name) &&
                Objects.equals(this.roles, teamMember.roles) &&
                Objects.equals(this.avatar, teamMember.avatar) &&
                Objects.equals(this.editable, teamMember.editable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, login, name, roles, avatar, editable);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamMember {\n");

        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    login: ").append(toIndentedString(login)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
        sb.append("    avatar: ").append(toIndentedString(avatar)).append("\n");
        sb.append("    editable: ").append(toIndentedString(editable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}


