package csbase.rest.adapter.execution_node.v1;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import ibase.rest.api.execution_node.v1.adapter.ExecutionNodeServiceAdapter;
import ibase.rest.model.execution_node.v1.ExecutionNode;

/**
 * Created by mjulia on 11/07/16.
 */
public class CSBaseExecutionNodeServiceAdapter implements ExecutionNodeServiceAdapter {

    /**
     * Atribui o locale a ser usado nas requisi��es ao servi�o.
     *
     * @param locale o locale com o idioma
     */
    @Override
    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    @Override
    public List<ExecutionNode> getExecutionResources(String algorithmId, String versionId, List<String> selectedPlataforms) {
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        AlgorithmServiceInterface algorithmService = ClientRemoteLocator.algorithmService;
        List<ExecutionNode> executionNodes = new ArrayList<>();
        try {
            Set<String> requirements=new HashSet<>();
            if (algorithmId !=null && versionId!=null && !versionId.isEmpty() && !algorithmId.isEmpty()) {
                AlgorithmVersionId algoVersionId = AlgorithmVersionId.create(versionId);
                AlgorithmConfigurator configurator = algorithmService.createAlgorithmConfigurator(algorithmId, algoVersionId);
                requirements = configurator.getRequirements();
                if (selectedPlataforms==null || selectedPlataforms.isEmpty()) 
                    selectedPlataforms = configurator.getPlatforms().stream().collect(Collectors.toList());
            }
            List<String> sgaNames = sgaService.getAllSGANames();
            for (String sgaName : sgaNames) {
                SGASet sga = sgaService.getSGASet(sgaName);
                if (sga != null && (selectedPlataforms==null || selectedPlataforms.isEmpty() ||  sga.isPlatformSupported(selectedPlataforms))
                        && (requirements==null || requirements.isEmpty() || sga.hasRequirements(requirements))
                        && sga.mayExecuteCommand()) {
                	ExecutionNode node = buildExecutionNode(sga);
                    executionNodes.add(node);
                }
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return executionNodes;
    }

    /**
     * Examples:
     * {@code get http://localhost:8010/v1/resources?cpu-ammount=0.6&memory-amount=9.9&java=true}
     * @param requirements
     * @return
     */
    @Override
    public List<ExecutionNode> getExecutionResources(String requirements) {
        List<ExecutionNode> resources = new ArrayList<>();
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        try {
            List<String> sgaNames = sgaService.getAllSGANames();
            List<SGASet> sgas = new ArrayList<>();
            for (String sgaName : sgaNames) {
                SGASet sga = sgaService.getSGASet(sgaName);
                if (sga.mayExecuteCommand()) {
                    sgas.add(sga);
                }
            }
            FilterByJsonRequirements filter = new FilterByJsonRequirements(requirements);
            sgas = filter.filter(sgas);
            sgas.stream().forEach(sga -> resources.add(buildExecutionNode(sga)));
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return resources;
    }

    private ExecutionNode buildExecutionNode(SGASet sga) {
        ExecutionNode node = new ExecutionNode();
        node.setName(sga.getName());
        node.setPlatform(sga.getPlatformId());
        return node;
    }


}
