/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1;

import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.JobHistoryEvent;
import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import csbase.exception.InfoException;
import csbase.exception.ServiceFailureException;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import csbase.rest.adapter.job.v1.event.JobHistoryEventFactory;
import csbase.rest.adapter.job.v1.util.CSBaseCommandUtil;
import csbase.server.Server;
import csbase.server.plugin.service.commandpersistenceservice.ICommandInfo;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import ibase.common.NotFoundException;
import ibase.common.ServiceUtil;
import ibase.exception.InternalServiceException;
import ibase.exception.InvalidParameterException;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;

public class JobMigration {
    private String kafkaServer;
    private String schemaRegistry;
    private String kafkaTopic;
    private HashMap<Class, Integer> exceptionStatistics;
    private HashMap<CommandStatus, Integer> statistics;
    private HashMap<String, HashMap> projectStatisticsByStatus;
    private HashMap<String, Integer> projectStatisticsByError;
    private HashMap<String, Integer> projectStatisticsBySuccess;
    private int cmdsProduced;
    public static final String RESOURCE_BUNDLE = "JobMigration";

    public JobMigration(String kafkaServer, String schemaRegistry, String kafkaTopic) {
        this.kafkaServer = kafkaServer;
        this.schemaRegistry = schemaRegistry;
        this.kafkaTopic = kafkaTopic;
    }

    public String getKafkaServer() {
        return this.kafkaServer;
    }

    public String getSchemaRegistry() {
        return this.schemaRegistry;
    }

    public String getKafkaTopic() {
        return this.kafkaTopic;
    }

    private ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    private HashMap<CommandStatus, Integer> getEmptyCommandStatusHashMap() {
        HashMap<CommandStatus, Integer> statistics = new HashMap<CommandStatus, Integer>();
        for (CommandStatus status : CommandStatus.values()) {
            statistics.put(status, 0);
        }
        return statistics;
    }

    private void initializeStatistics() {
        this.statistics = this.getEmptyCommandStatusHashMap();
        this.exceptionStatistics = new HashMap();
        this.projectStatisticsByError = new HashMap();
        this.projectStatisticsBySuccess = new HashMap();
        this.projectStatisticsByStatus = new HashMap();
        this.cmdsProduced = 0;
    }

    private void printStatistics() {
        Server.logInfoMessage((String)"Printing some statistics...");
        for (CommandStatus status : CommandStatus.values()) {
            Server.logInfoMessage((String)("Quantity of commands " + status + ": " + this.statistics.get(status)));
        }
        Server.logInfoMessage((String)("Quantity of commands produced: " + this.cmdsProduced));
        Server.logInfoMessage((String)"Migration Exceptions...");
        for (Class clazz : this.exceptionStatistics.keySet()) {
            Server.logInfoMessage((String)(clazz.getName() + " : " + this.exceptionStatistics.get(clazz)));
        }
        Server.logInfoMessage((String)"Migration by Projects:");
        for (String projectId : this.projectStatisticsByStatus.keySet()) {
            Server.logInfoMessage((String)("ProjectID " + projectId + ": "));
            HashMap pstatistics = this.projectStatisticsByStatus.get(projectId);
            for (CommandStatus status : pstatistics.keySet()) {
                Server.logInfoMessage((String)("---- Quantity of commands " + status + ": " + pstatistics.get(status)));
            }
            Server.logInfoMessage((String)("---- Quantity of migrated: " + this.projectStatisticsBySuccess.get(projectId)));
            Server.logInfoMessage((String)("---- Quantity of errors: " + this.projectStatisticsByError.get(projectId)));
        }
    }

    private Producer<String, JobHistoryEvent> getProducer() {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", this.getKafkaServer());
        properties.setProperty("schema.registry.url", this.getSchemaRegistry());
        properties.setProperty("key.serializer", StringSerializer.class.getName());
        properties.setProperty("value.serializer", KafkaAvroSerializer.class.getName());
        properties.setProperty("acks", "1");
        properties.setProperty("retries", "3");
        properties.setProperty("linger.ms", "1");
        return new KafkaProducer(properties);
    }

    private List<JobHistoryEvent> createJobHistoryEvent(CommandInfo command, JobHistoryEventFactory factory) {
        ArrayList<JobHistoryEvent> events = new ArrayList<JobHistoryEvent>();
        ICommandInfo commandInfo = CSBaseCommandUtil.buildIcommandInfo(command);
        switch (commandInfo.getStatus()) {
            case SCHEDULED: {
                JobScheduledEvent event = factory.buildScheduledEvent(commandInfo, command);
                events.add(new JobHistoryEvent(event.getClass().getSimpleName(), (Object)event));
                return events;
            }
            case FINISHED: {
                JobScheduledEvent scheduleEvent = factory.buildScheduledEvent(commandInfo, command);
                JobFinishedEvent finishedEvent = factory.buildFinishedEvent(commandInfo, command);
                events.add(new JobHistoryEvent(scheduleEvent.getClass().getSimpleName(), (Object)scheduleEvent));
                events.add(new JobHistoryEvent(finishedEvent.getClass().getSimpleName(), (Object)finishedEvent));
                return events;
            }
            case UPLOADING: 
            case DOWNLOADING: 
            case EXECUTING: 
            case RESCHEDULED: 
            case INIT: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported ICommandInfo status");
    }

    private void catchErrorJob(Exception e, CommandInfo command) {
        String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("migrateJobs.error", new String[]{command.getId(), e.getCause().getMessage()});
        if (e.getCause().getClass().equals(NullPointerException.class)) {
            e.printStackTrace();
        }
        if (!this.exceptionStatistics.containsKey(e.getCause().getClass())) {
            this.exceptionStatistics.put(e.getCause().getClass(), 1);
        } else {
            this.exceptionStatistics.put(e.getCause().getClass(), this.exceptionStatistics.get(e.getCause().getClass()) + 1);
        }
        Server.logSevereMessage((String)message);
    }

    private void catchErrorProject(Exception ep, String projectId) {
        Class<?> c = ep.getClass();
        String msg = ep.getMessage();
        if (ep.getCause() != null) {
            msg = ep.getCause().getMessage();
            c = ep.getCause().getClass();
        }
        String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("migrateJobs.commandinfo.error", new String[]{projectId, msg});
        if (!this.exceptionStatistics.containsKey(c)) {
            this.exceptionStatistics.put(c, 1);
        } else {
            this.exceptionStatistics.put(c, this.exceptionStatistics.get(c) + 1);
        }
    }

    private void sendAllEventsToKafka(List<JobHistoryEvent> jobHistoryEvents, Producer<String, JobHistoryEvent> producer, CommandInfo command) {
        if (jobHistoryEvents != null) {
            for (JobHistoryEvent event : jobHistoryEvents) {
                producer.send(new ProducerRecord(this.getKafkaTopic(), (Object)command.getId(), (Object)event));
            }
            ++this.cmdsProduced;
        }
    }

    private void updateStatisticsOfProject(CommandStatus commandStatus, String projectId, boolean sucess) {
        if (!this.projectStatisticsByStatus.containsKey(projectId)) {
            this.projectStatisticsByStatus.put(projectId, new HashMap());
        }
        if (!this.projectStatisticsByStatus.get(projectId).containsKey(commandStatus)) {
            this.projectStatisticsByStatus.get(projectId).put(commandStatus, 0);
        }
        this.projectStatisticsByStatus.get(projectId).put(commandStatus, (Integer)this.projectStatisticsByStatus.get(projectId).get(commandStatus) + 1);
        if (!this.projectStatisticsByError.containsKey(projectId)) {
            this.projectStatisticsByError.put(projectId, 0);
        }
        if (!this.projectStatisticsBySuccess.containsKey(projectId)) {
            this.projectStatisticsBySuccess.put(projectId, 0);
        }
        if (sucess) {
            this.projectStatisticsBySuccess.put(projectId, this.projectStatisticsBySuccess.get(projectId) + 1);
        } else {
            this.projectStatisticsByError.put(projectId, this.projectStatisticsByError.get(projectId) + 1);
        }
    }

    private List<UserProjectInfo> getAllProjects() {
        ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
        AdministrationServiceInterface adminService = ClientRemoteLocator.administrationService;
        try {
            List users = adminService.getAllUsers();
            ArrayList<UserProjectInfo> allProjects = new ArrayList<UserProjectInfo>();
            for (User user : users) {
                allProjects.addAll(projectService.getProjectsFromUser(user.getId()));
            }
            return allProjects;
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void migrateJobs() {
        this.initializeStatistics();
        List<UserProjectInfo> allProjects = this.getAllProjects();
        CommandPersistenceService persistence = CommandPersistenceService.getInstance();
        Thread.currentThread().setContextClassLoader(null);
        ExecutorService migrateJobsExecutor = Executors.newSingleThreadExecutor();
        migrateJobsExecutor.execute(() -> {
            Producer<String, JobHistoryEvent> producer = this.getProducer();
            for (UserProjectInfo projectInfo : allProjects) {
                String projectId = (String)projectInfo.getProjectId();
                Server.logInfoMessage((String)("Project job migration : " + projectId));
                try {
                    Set commands = persistence.getCommandInfos((Object)projectId);
                    JobHistoryEventFactory factory = new JobHistoryEventFactory();
                    for (CommandInfo command : commands) {
                        boolean sucess = true;
                        try {
                            List<JobHistoryEvent> jobHistoryEvents = this.createJobHistoryEvent(command, factory);
                            this.sendAllEventsToKafka(jobHistoryEvents, producer, command);
                        }
                        catch (Exception e) {
                            this.catchErrorJob(e, command);
                            sucess = false;
                        }
                        finally {
                            this.statistics.put(command.getStatus(), this.statistics.get(command.getStatus()) + 1);
                            this.updateStatisticsOfProject(command.getStatus(), projectId, sucess);
                        }
                    }
                }
                catch (Exception ep) {
                    this.catchErrorProject(ep, projectId);
                }
            }
            this.printStatistics();
        });
    }
}

